/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.admin.api.dto.UserDTO;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUser;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.BusinessUserVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.UserVO;
import com.yifu.cloud.plus.v1.yifu.common.ldap.entity.PersonVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 用户表 Mapper 接口
 * </p>
 *
 * @author lengleng
 * @since 2019/2/1
 */
@Mapper
public interface SysUserMapper extends BaseMapper<SysUser> {

	/**
	 * 通过用户名查询用户信息（含有角色信息）
	 * @param username 用户名
	 * @return userVo
	 */
	UserVO getUserVoByUsername(String username);

	/**
	 * 分页查询用户信息（含角色）
	 * @param page 分页
	 * @param userDTO 查询参数
	 * @return list
	 */
	IPage<List<UserVO>> getUserVosPage(Page page, @Param("query") UserDTO userDTO);

	/**
	 * 通过ID查询用户信息
	 * @param id 用户ID
	 * @return userVo
	 */
	UserVO getUserVoById(String id);

	/**
	 * 查询用户列表
	 * @param userDTO 查询条件
	 * @return
	 */
	List<UserVO> selectVoList(@Param("query") UserDTO userDTO);

	void batchInsertUser(@Param("list") List<PersonVo> list);

	void batchUpdateUser(@Param("list") List<PersonVo> list);

	void updateUser(@Param("list") List<Map<String,Object>> list);

	Page<BusinessUserVo> getBusinessUserVoPage(Page page,@Param("query") BusinessUserVo user);

	List<SysUser> getUserByRoleIdForCrm(@Param("departId") Integer departId, @Param("roleId") String roleId);

	List<SysUser> getUserManagerByUpDepartIdUp(@Param("departId") Integer departId,  @Param("roleId")String roleId);

	String selectExitDeptCompany(@Param("deptId") String deptId);
}
