/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascEditLog;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 法大大编辑日志表
 *
 * @author hgw
 * @date 2025-10-09 10:39:43
 */
@Mapper
public interface TFascEditLogMapper extends BaseMapper<TFascEditLog> {
	/**
	 * 法大大编辑日志表简单分页查询
	 *
	 * @param tFascEditLog 法大大编辑日志表
	 * @return
	 */
	IPage<TFascEditLog> getTFascEditLogPage(Page<TFascEditLog> page, @Param("tFascEditLog") TFascEditLog tFascEditLog);
	List<TFascEditLog> getTFascEditLogList(@Param("tFascEditLog") TFascEditLog tFascEditLog);
}
