package com.yifu.cloud.plus.v1.yifu.permission.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 企业微信出差
 */
@TableName(value = "ekp_qiwei_zhaopin")
@Data
@Schema(description = "企业微信招聘")
public class EkpQiwiZhaoPin {

	@TableField(exist = false)
	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键", name = "fdId")
	private String fdId;

	@Schema(description = "审批编号")
	@NotBlank(message = "审批编号不能为空")
	private String fdSpNo;

	@Schema(description = "申请人姓名")
	@NotBlank(message = "申请人姓名不能为空")
	private String fdApplyUserName;

	@Schema(description = "申请人部门")
	@NotBlank(message = "申请人部门不能为空")
	private String fdApplyUserDept;

	@Schema(description = "申请日期")
	@NotNull(message = "申请日期不能为空")
	private LocalDateTime fdApplyDate;

	@Schema(description = "开始时间")
	private LocalDate fdNewBegin;
	@Schema(description = "结束时间")
	private LocalDate fdNewEnd;

	// 关联状态 0未关联；1已关联；
	@Schema(description = "关联状态")
	private String fdStatus;

	@Schema(description = "创建申请时间")
	private LocalDateTime createTime;

	@Schema(description = "同步这条数据时间")
	private LocalDateTime createDataTime;

	// 企微、HCM
	@Schema(description = "数据源")
	private String fdDataSource;

	// 新字段
	@Schema(description = "申请子 (分) 公司或部门名称")
	@NotBlank(message = "申请子 (分) 公司或部门名称")
	private String fdUserDeptName;
	@Schema(description = "购买方式")
	private String fdBuyStyle;
	@Schema(description = "平台名称")
	private String fdPingTaiName;
	@Schema(description = "平台产品名称")
	private String fdPingTaiChanPin;
	@Schema(description = "数量")
	private String fdNum;
	@Schema(description = "单价")
	private String fdMoney;
	@Schema(description = "总计金额")
	private String fdMoneySum;
	@Schema(description = "使用项目名称")
	private String fdDeptName;
	@Schema(description = "使用岗位名称")
	private String fdPostName;
	@Schema(description = "成本归属")
	private String fdCostName;
	// 招聘运营部填写
	@Schema(description = "购买/调配方式是否合理")
	private String fdTwoIsHeLi;
	@Schema(description = "平台名称")
	private String fdTwoPingTaiName;
	@Schema(description = "产品名称")
	private String fdTwoPingTaiChanPin;
	@Schema(description = "数量")
	private String fdTwoNum;
	@Schema(description = "金额")
	private String fdTwoMoneySum;
	@Schema(description = "被调配的业务单元名称")
	private String fdTwoYeWu;
	@Schema(description = "备注")
	private String fdTwoRemark;
	@Schema(description = "关联结算单号")
	private String fdSettleFormNo;

}