package com.yifu.cloud.plus.v1.business.controller.system;

import com.yifu.cloud.plus.v1.business.entity.system.TBusAttaInfo;
import com.yifu.cloud.plus.v1.business.service.system.TBusAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * B端附件表
 *
 * @author hgw
 * @date 2021-08-12 16:38:51
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tbusattainfo")
@Tag(name = "B端附件表")
public class TBusAttaInfoController {

     private final TBusAttaInfoService tBusAttaInfoService;

     /**
      * 获取附件list，一般传参relationId即可
      *
      * @param tBusAttaInfo B端附件表
      * @return
      */
     @Operation(description = "获取附件list，一般传参relationId即可")
     @GetMapping("/getBusAttaList")
     public R<List<TBusAttaInfo>> getBusAttaList(TBusAttaInfo tBusAttaInfo) {
          return new R<>(tBusAttaInfoService.getBusAttaList(tBusAttaInfo));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TBusAttaInfo> getById(@PathVariable("id") String id) {
          return new R<>(tBusAttaInfoService.getUrlByid(id));
     }


}
