/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 申报对象表
 *
 * @author huyc
 * @date 2022-08-11 10:56:10
 */
@Data
@TableName("t_statistics_declarer")
@EqualsAndHashCode()
@Schema(description = "申报对象表")
public class TStatisticsDeclarer {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelIgnore
	private String id;
	/**
	 * 申报单位
	 */
	@ExcelAttribute(name = "申报单位", maxLength = 50)
	@Length(max = 50, message = "申报单位不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	private String declareUnit;
	/**
	 * 申报月份
	 */
	@ExcelAttribute(name = "申报月份", isNotEmpty = true, errorInfo = "申报月份不能为空", maxLength = 6)
	@NotBlank(message = "申报月份不能为空")
	@Length(max = 6, message = "申报月份不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 20)
	@Length(max = 20, message = "姓名不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	@Length(max = 11, message = "手机号码不能超过11个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 任职受雇从业类型
	 */
	@Length(max = 2, message = "任职受雇从业类型不能超过2个字符")
	@ExcelAttribute(name = "任职受雇从业类型", maxLength = 2,readConverterExp = "0=雇员,1=其他")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("任职受雇从业类型")
	private String occupationType;
	/**
	 * 任职受雇从业日期
	 */
	@Length(max = 20, message = "任职受雇从业日期不能超过20个字符")
	@ExcelIgnore
	private String occupationMonth;
	/**
	 * 本月是否申报 0 是 1 否
	 */
	@ExcelAttribute(name = "本期是否申报", maxLength = 1,readConverterExp = "0=是,1=否")
	@Length(max = 1, message = "本期是否申报不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期是否申报")
	private String isDeclare;
	/**
	 * 不申报原因
	 */
	@ExcelAttribute(name = "不申报原因", maxLength = 200)
	@Length(max = 200, message = "不申报原因不能超过200个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("不申报原因")
	private String undeclareReason;
	/**
	 * 是否0申报人员 0 是 1 否
	 */
	@ExcelAttribute(name = "是否0申报人员", maxLength = 1,readConverterExp = "0=是,1=否")
	@Length(max = 1, message = "是否0申报人员不能超过1个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否0申报人员")
	private String isZeroDeclare;
	/**
	 * 是否0申报人员 0 是 1 否
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String isZeroFlag;
}
