/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.LocalDateTimeUtils;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.DecimalMax;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 员工不良记录
 *
 * @author fxj
 * @date 2022-06-29 15:50:45
 */
@Data
@TableName("t_emp_bad_record")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工不良记录")
public class TEmpBadRecord extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "主键" )
    @Schema(description ="主键")
	@ExcelIgnore
    private String id;

    /**
     * 员工姓名
     */
    @ExcelAttribute(name = "员工姓名" ,maxLength = 20)
    @Schema(description ="员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
    private String empName;

    /**
     * 员工ID
     */
    @ExcelAttribute(name = "员工ID")
    @Schema(description ="员工ID")
	@ExcelIgnore
    private String empId;

    /**
     * 身份证号
     */
    @ExcelAttribute(name = "身份证号" ,maxLength = 20)
    @Schema(description ="身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
    private String empIdcard;

	/**
	 * 是否有不良记录 0 是 1 否
	 */
	@ExcelAttribute(name = "是否有不良记录" , isNotEmpty = true, errorInfo = "是否有不良记录不可为空",readConverterExp = "0=是,1=否")
	@Schema(description ="是否有不良记录 0 是 1 否 ")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ColumnWidth(20)
	@ExcelProperty("是否有不良记录")
	private String badRecordFlag;

    /**
     * 产生项目
     */
    @ExcelAttribute(name = "产生项目" ,maxLength = 50)
    @Schema(description ="产生项目")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("产生项目")
    private String project;

    /**
     * 项目编码
     */
    @ExcelAttribute(name = "项目编码" ,maxLength = 50)
    @Schema(description ="项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
    private String projectCode;

    /**
     * 发生时间
     */
    @ExcelAttribute(name = "发生时间",isDate = true, dateFormat = LocalDateTimeUtils.DATE_TIME_PATTERN_DEFAULT)
	@DateTimeFormat("yyyy-MM-dd")
    @Schema(description ="发生时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发生时间")
    private Date happenTime;

    /**
     * 备注
     */
    @ExcelAttribute(name = "不良记录描述", maxLength = 200)
    @Schema(description ="不良记录描述")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("不良记录描述")
    private String remark;

    /**
     * 费用损失 （费用损失与其他费用损失其一必填）
     */
    @ExcelAttribute(name = "费用损失", isFloat = true,max = "999999999.99")
    @Schema(description ="费用损失 （费用损失与其他费用损失其一必填）")
	@DecimalMax(value = "999999999.99", message = "费用损失不可大于999999999.99")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("费用损失")
    private BigDecimal loseFee;

    /**
     * 其他损失 （费用损失与其他费用损失其一必填）
     */
    @ExcelAttribute(name = "其他损失" )
    @Schema(description ="其他损失 （费用损失与其他费用损失其一必填）")
	@DecimalMax(value = "999999999.99", message = "其他损失不可大于999999999.99")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("其他损失")
    private BigDecimal loseFeeOther;


	/**
	 * 项目ID
	 */
	@ExcelIgnore
	@Schema(description ="项目ID")
	private String  settleDomain;

	/**
	 * @Author fxj
	 * @Description 附件ID
	 * @Date 14:53 2022/6/21
	 **/
	@TableField(exist = false)
	@ExcelIgnore
	private String attaIds;

}
