/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.time.LocalDateTime;

/**
 * 项目档案所属部门表
 *
 * @author hgw
 * @date 2025-02-28 15:03:17
 */
@Data
@TableName("t_employee_project_belong_dept")
@Schema(description = "项目档案所属部门表")
public class TEmployeeProjectBelongDept {

	/**
	 * 项目档案ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("项目档案ID")
	@Schema(description = "项目档案ID")
	private String id;
	/**
	 * 所属部门名称
	 */
	@ExcelAttribute(name = "所属部门名称", maxLength = 30)
	@Length(max = 30, message = "所属部门名称不能超过30个字符")
	@ExcelProperty("所属部门名称")
	@Schema(description = "所属部门名称")
	private String empDeptname;
	/**
	 * 所属部门id
	 */
	@ExcelAttribute(name = "所属部门id", maxLength = 36)
	@Length(max = 36, message = "所属部门id不能超过36个字符")
	@ExcelProperty("所属部门id")
	@Schema(description = "所属部门id")
	private String empDeptid;

	// 日志确认接收时间，与项目档案日期比较
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@TableField(exist = false)
	private LocalDateTime logCreateTime;

}
