/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 *
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveJobVo implements Serializable {

	private static final long serialVersionUID = 1L;
	// 工作单位
	@Schema(description = "公司名称")
	private String companyName;
	// 工作部门
	@Schema(description = "部门")
	private String deptName;
	// 工作岗位
	@Schema(description = "职位")
	private String jobName;
	// 开始工作日期
	@Schema(description = "开始日期")
	private String joinDate;
	// 结束工作日期
	@Schema(description = "结束日期")
	private String leaveDate;
	// 无
	@Schema(description = "职位描述")
	private String remark;

}
