package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2023/10/17
 * @Description 社保公积金审核权限VO
 * @Version 1.0
 */
@Data
public class SocialAuthImportVo extends RowIndex implements Serializable {
	@ExcelAttribute(name = "登录账号", maxLength = 30,isNotEmpty = true)
	@Schema(description = "登录账号")
	private String userLoginName;

	/**
	 * 户类型：0社保 1公积金
	 */
	@Schema(description ="户类型：0社保 1公积金")
	@ExcelAttribute(name = "户类型：0社保 1公积金", maxLength = 32,isNotEmpty = true,isDataId = true,readConverterExp = "0=社保,1=公积金")
	private String type;

	@Length(max = 32, message = "户名称不能超过32个字符")
	@ExcelAttribute(name = "户名称", maxLength = 32,isNotEmpty = false)
	@Schema(description = "户名称")
	private String houseHold;

}
