package com.yifu.cloud.plus.v1.business.controller.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfigTitleRes;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryConfigTitleResService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * B端-原表表头与配置关联表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbussalaryconfigtitleres")
@Tag(name = "B端-原表表头与配置关联表")
public class TBusSalaryConfigTitleResController {

     private final TBusSalaryConfigTitleResService tBusSalaryConfigTitleResService;

     /**
      * 简单分页查询
      *
      * @param page                     分页对象
      * @param tBusSalaryConfigTitleRes B端-原表表头与配置关联表
      * @return
      */
     @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TBusSalaryConfigTitleRes>> getTBusSalaryConfigTitleResPage(Page<TBusSalaryConfigTitleRes> page, TBusSalaryConfigTitleRes tBusSalaryConfigTitleRes) {
          return new R<>(tBusSalaryConfigTitleResService.getTBusSalaryConfigTitleResPage(page, tBusSalaryConfigTitleRes));
     }

     /**
      * 获取list
      * @return
      */
     @Operation(summary = "获取之前保存的list，deptId必填")
     @GetMapping("/getResListByDeptId")
     public R<List<TBusSalaryConfigTitleRes>> getResListByDeptId(@RequestParam Integer deptId) {
          return new R<>(tBusSalaryConfigTitleResService.getResListByDeptId(deptId));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TBusSalaryConfigTitleRes> getById(@PathVariable("id") String id) {
          return new R<>(tBusSalaryConfigTitleResService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tBusSalaryConfigTitleRes
      * @return R
      */
     @Operation(summary = "新增(yifu-hro-business:tbussalaryconfigtitleres_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfigtitleres_add')")
     public R<Boolean> save(@Valid @RequestBody TBusSalaryConfigTitleRes tBusSalaryConfigTitleRes) {
          return new R<>(tBusSalaryConfigTitleResService.save(tBusSalaryConfigTitleRes));
     }

     /**
      * 修改记录
      *
      * @param tBusSalaryConfigTitleRes
      * @return R
      */
     @Operation(summary = "修改(yifu-hro-business:tbussalaryconfigtitleres_edit)")
     @SysLog("修改B端-原表表头与配置关联表")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfigtitleres_edit')")
     public R<Boolean> update(@RequestBody TBusSalaryConfigTitleRes tBusSalaryConfigTitleRes) {
          return new R<>(tBusSalaryConfigTitleResService.updateById(tBusSalaryConfigTitleRes));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "删除(yifu-hro-business:tbussalaryconfigtitleres_del)")
     @SysLog("删除B端-原表表头与配置关联表")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussalaryconfigtitleres_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tBusSalaryConfigTitleResService.removeById(id));
     }

}
