package com.yifu.cloud.plus.v1.csp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 系统限制配置表
 *
 * @author huych
 * @date 2025-05-16 11:39:57
 */
@Data
@TableName("sys_config_limit")
@Schema(description = "系统限制配置表")
public class SysConfigLimit {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 限制键
	 */
	@ExcelAttribute(name = "限制键", isNotEmpty = true, errorInfo = "限制键不能为空", maxLength = 32)
	@NotBlank(message = "限制键不能为空")
	@Length(max = 32, message = "限制键不能超过32个字符")
	@ExcelProperty("限制键")
	@Schema(description = "限制键")
	private String configKey;
	/**
	 * 限制值
	 */
	@ExcelAttribute(name = "限制值", isNotEmpty = true, errorInfo = "限制值不能为空")
	@NotBlank(message = "限制值不能为空")
	@ExcelProperty("限制值")
	@Schema(description = "限制值")
	private Integer configValue;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Length(max = 255, message = "备注不能超过255个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

}
