package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchasePerson;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonAddVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
public interface TInsuranceUnpurchasePersonService extends IService<TInsuranceUnpurchasePerson> {
    /**
     * 含风险项目不购买申请明细表简单分页查询
     * @param tInsuranceUnpurchasePerson 含风险项目不购买申请明细表
     * @return
     */
    IPage<TInsuranceUnpurchasePerson> getTInsuranceUnpurchasePersonPage(Page<TInsuranceUnpurchasePerson> page, TInsuranceUnpurchasePersonSearchVo tInsuranceUnpurchasePerson);

    void listExport(HttpServletResponse response, TInsuranceUnpurchasePersonSearchVo searchVo);

	List<TInsuranceUnpurchasePersonAddVo> getTInsuranceUnpurchasePersonList(String id);

	List<TInsuranceUnpurchasePerson> getBuyList(String deptNo, List<String> idCardList);

	/**
	 * @param id 明细id
	 * @Description: 刷新社保状态
	 * @Author: hgw
	 * @Date: 2025/1/15 13:13
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> getSocialWorkInjuryHandleById(String id);

	R<TInsuranceUnpurchasePerson> getPersonInfo(String id);

	void doSocialWorkInjuryHandleAll();

}
