/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * @author fxj
 * @date 2024-05-08 11:52:08
 */
@Data
@TableName("t_holiday_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "节假日信息表")
public class THolidayInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * date 例:2024-05-08
	 */
	@ExcelAttribute(name = "date", isDate = true)
	@ExcelProperty("date")
	@Schema(description = "date")
	private Date date;
	/**
	 * year 例:2024
	 */
	@ExcelAttribute(name = "year", maxLength = 6)
	@Length(max = 6, message = "year不能超过6个字符")
	@ExcelProperty("year")
	@Schema(description = "year")
	private String year;
	/**
	 * month  例:05
	 */
	@ExcelAttribute(name = "month", maxLength = 6)
	@Length(max = 6, message = "month不能超过6个字符")
	@ExcelProperty("month")
	@Schema(description = "month")
	private String month;
	/**
	 * day  例:08
	 */
	@ExcelAttribute(name = "day", maxLength = 2)
	@Length(max = 2, message = "day不能超过2个字符")
	@ExcelProperty("day")
	@Schema(description = "day")
	private String day;
}
