/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpBadRecord;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpBadRecordService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpBadRecordSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Arrays;
import java.util.List;


/**
 * 员工不良记录
 *
 * @author fxj
 * @date 2022-06-29 15:50:45
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempbadrecord" )
@Tag(name = "员工不良记录管理")
public class TEmpBadRecordController {

    private final TEmpBadRecordService tEmpBadRecordService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param tEmpBadRecord 员工不良记录
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    //@PreAuthorize("@pms.hasPermission('demo_tempbadrecord_get')" )
    public R<IPage<TEmpBadRecord>> getTEmpBadRecordPage(Page page, EmpBadRecordSearchVo tEmpBadRecord) {
        return R.ok(tEmpBadRecordService.pageDiy(page, tEmpBadRecord));
    }
    /**
     * 不分页查询
     * @param tEmpBadRecord 员工不良记录
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tempbadrecord_get')" )
    public R<List<TEmpBadRecord>> getTEmpBadRecordNoPage(@RequestBody EmpBadRecordSearchVo tEmpBadRecord) {
        return R.ok(tEmpBadRecordService.noPageDiy(tEmpBadRecord));
    }

    /**
     * 通过id查询员工不良记录
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tempbadrecord_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tempbadrecord_get')" )
    public R<TEmpBadRecord> getById(@PathVariable("id" ) String id) {
        return R.ok(tEmpBadRecordService.getById(id));
    }

    /**
     * 新增员工不良记录
     * @param tEmpBadRecord 员工不良记录
     * @return R
     */
    @Operation(summary = "新增员工不良记录", description = "新增员工不良记录：hasPermission('demo_tempbadrecord_add')")
    @SysLog("新增员工不良记录" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tempbadrecord_add')" )
    public R<Boolean> save(@Valid @RequestBody TEmpBadRecord tEmpBadRecord) {
        return tEmpBadRecordService.saveDiy(tEmpBadRecord);
    }

    /**
     * 修改员工不良记录
     * @param tEmpBadRecord 员工不良记录
     * @return R
     */
    @Operation(summary = "修改员工不良记录", description = "修改员工不良记录：hasPermission('demo_tempbadrecord_edit')")
    @SysLog("修改员工不良记录" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tempbadrecord_edit')" )
    public R<Boolean> updateById(@Valid @RequestBody TEmpBadRecord tEmpBadRecord) {
        return tEmpBadRecordService.updateDiy(tEmpBadRecord);
    }

    /**
     * 通过id删除员工不良记录
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除员工不良记录", description = "通过id删除员工不良记录：hasPermission('demo_tempbadrecord_del')")
    @SysLog("通过id删除员工不良记录" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tempbadrecord_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tEmpBadRecordService.removeById(id));
    }


	/**
	 * 通过ids删除员工不良记录
	 * @param  ids
	 * @return R
	 */
	@Operation(summary = "通过ids删除员工不良记录", description = "通过id删除员工不良记录：hasPermission('demo_tempbadrecord_del_batch')")
	@SysLog("通过ids删除员工不良记录" )
	@DeleteMapping("/removeByIds" )
	@PreAuthorize("@pms.hasPermission('demo_tempbadrecord_del_batch')" )
	public R<Boolean> removeByIds(@RequestBody(required = true)  String[] ids) {
		List<String> idList = Arrays.asList(ids);
		return R.ok(tEmpBadRecordService.removeByIds(idList));
	}

	/**
	 * 批量新增不良记录信息
	 *
	 * @param file
	 * @return
	 * @Author fxj
	 * @Date 2019-08-16
	 **/
	@SneakyThrows
	@Operation(description = "批量新增不良记录信息 hasPermission('archives_tempbadrecord_importListAdd')")
	@SysLog("批量新增不良记录信息")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('archives_tempbadrecord_importListAdd')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tEmpBadRecordService.importEmpBadRecordDiy(file.getInputStream());
	}

	/**
	 * 批量导出不良记录信息
	 * @param searchVo
	 * @return R<List>
	 * @Author FXJ
	 * @Date 2022-06-21
	 **/
	@Operation(description = "导出")
	@PostMapping("/export")
	public void export(HttpServletResponse response, @RequestBody EmpBadRecordSearchVo searchVo) {
		tEmpBadRecordService.listExport(response,searchVo);
	}
}
