/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 项目配置表主表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
public class TAutoMainRelVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 项目编码
	 */
	@NotBlank(message = "项目编码 不能为空")
	@Length(max = 50, message = "项目编码 不能超过50 个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码 不能为空", maxLength = 50)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String projectNo;
	/**
	 * 项目ID
	 */
	@NotBlank(message = "项目ID 不能为空")
	@Length(max = 32, message = "项目ID 不能超过32 个字符")
	@ExcelAttribute(name = "项目ID", isNotEmpty = true, errorInfo = "项目ID 不能为空", maxLength = 32)
	@Schema(description = "项目ID")
	@ExcelProperty("项目ID")
	private String projectId;
	/**
	 * 规则最新更新时间
	 */
	@ExcelAttribute(name = "规则最新更新时间", isDate = true)
	@Schema(description = "规则最新更新时间")
	@ExcelProperty("规则最新更新时间")
	private Date ruleUpdateTime;
	/**
	 * 规则最新更新人
	 */
	@Length(max = 50, message = "规则最新更新人 不能超过50 个字符")
	@ExcelAttribute(name = "规则最新更新人", maxLength = 50)
	@Schema(description = "规则最新更新人")
	@ExcelProperty("规则最新更新人")
	private String ruleUpdatePerson;

}
