/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TFascTemplate;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TFascTemplateSearchVo;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 法大大专业版模板表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
public interface TFascTemplateService extends IService<TFascTemplate> {
    /**
     * 法大大专业版模板表简单分页查询
     * @param tFascTemplate 法大大专业版模板表
     * @return
     */
    IPage<TFascTemplate> getTFascTemplatePage(Page<TFascTemplate> page, TFascTemplateSearchVo tFascTemplate);
	// 获取列表，包含已删除（可以选择过滤）
    List<TFascTemplate> getTFascTemplateListAll(TFascTemplateSearchVo tFascTemplate);

    R<List<ErrorMessage>> batchUpdate(InputStream inputStream);

    void listExport(HttpServletResponse response, TFascTemplateSearchVo searchVo);

    List<TFascTemplate> noPageDiy(TFascTemplateSearchVo searchVo);
}
