/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * 缴费库
 *
 * @author huyc
 * @date 2022-07-14 18:53:42
 */
@Data
@TableName("t_payment_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "缴费库")
public class TPaymentInfo extends BaseEntity {

    /**
     * 主键
     */
    @Schema(description ="主键")
    private String id;

    /**
     * 员工姓名
     */
    @ExcelAttribute(name = "员工姓名" )
    @Schema(description ="员工姓名")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	@Size(max = 20, message = "员工姓名不可超过20位")
    private String empName;

    /**
     * 员工编码
     */
    @ExcelAttribute(name = "员工编码" )
    @Schema(description ="员工编码")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	@Size(max = 32, message = "员工编码不可超过32位")
    private String empNo;

    /**
     * 员工ID
     */
    @ExcelAttribute(name = "员工ID" )
    @Schema(description ="员工ID")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工ID")
    private String empId;

    /**
     * 身份证号
     */
    @ExcelAttribute(name = "身份证号" )
    @Schema(description ="身份证号")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	@Size(max = 32, message = "身份证号不可超过32位")
    private String empIdcard;

    /**
     * 客户名称
     */
    @ExcelAttribute(name = "客户名称" )
    @Schema(description ="客户名称")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
    private String unitName;

	/**
	 * 客户Id
	 */
	@ExcelAttribute(name = "客户Id" )
	@Schema(description ="客户Id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户Id")
	private String unitId;

    /**
     * 项目id
     */
    @ExcelAttribute(name = "项目id" )
    @Schema(description ="项目id")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
    private String settleDomainId;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称" )
	@Schema(description ="项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	/**
	 * 项目编码
	 */
	@Length(max = 50, message = "项目编码不能超过50个字符" )
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String settleDomainCode;

    /**
     * 社保户
     */
    @ExcelAttribute(name = "社保户" )
    @Schema(description ="社保户")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
    private String socialHousehold;

    /**
     * 社保编号
     */
    @ExcelAttribute(name = "社保编号" )
    @Schema(description ="社保编号")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保编号")
    private String socialSecurityNo;

    /**
     * 社保缴纳地
     */
    @ExcelAttribute(name = "社保缴纳地" )
    @Schema(description ="社保缴纳地")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地")
    private String socialPayAddr;

    /**
     * 社保缴纳月份
     */
    @ExcelAttribute(name = "社保缴纳月份", maxLength = 6,isInteger = true)
    @Schema(description ="社保缴纳月份")
	@Length(max = 6, message = "社保缴纳月份不能超过6个字符")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
    private String socialPayMonth;

    /**
     * 社保生成月份
     */
    @ExcelAttribute(name = "社保生成月份",  maxLength = 6,isInteger = true)
	@Length(max = 6, message = "社保生成月份不能超过6个字符")
    @Schema(description ="社保生成月份")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
    private String socialCreateMonth;

    /**
     * 确认无误状态 0 未确认 1 已确认
     */
    @ExcelAttribute(name = "确认无误状态 0 未确认 1 已确认" )
    @Schema(description ="确认无误状态 0 未确认 1 已确认")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("确认无误状态 0 未确认 1 已确认")
    private String lockStatus;

    /**
     * 总合计
     */
    @ExcelAttribute(name = "总合计" )
    @Schema(description ="总合计")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("总合计")
    private BigDecimal sumAll;

    /**
     * 公积金缴纳月份
     */
    @ExcelAttribute(name = "公积金缴纳月份",  maxLength = 6,isInteger = true)
	@Length(max = 6, message = "公积金缴纳月份不能超过6个字符")
    @Schema(description ="公积金缴纳月份")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳月份")
    private String providentPayMonth;

    /**
     * 公积金生成月份
     */
    @ExcelAttribute(name = "公积金生成月份",  maxLength = 6,isInteger = true)
	@Length(max = 6, message = "公积金生成月份不能超过6个字符")
    @Schema(description ="公积金生成月份")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金生成月份")
    private String providentCreateMonth;

    /**
     * 公积金户
     */
    @ExcelAttribute(name = "公积金户" )
    @Schema(description ="公积金户")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
    private String providentHousehold;

    /**
     * 公积金缴纳地
     */
    @ExcelAttribute(name = "公积金缴纳地" )
    @Schema(description ="公积金缴纳地")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地")
    private String providentPayAddr;

    /**
     * 公积金缴纳地-省
     */
    @ExcelAttribute(name = "公积金缴纳地-省", isArea = true)
    @Schema(description ="公积金缴纳地-省")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省")
    private String fundProvince;

    /**
     * 公积金缴纳地-市
     */
    @ExcelAttribute(name = "公积金缴纳地-市",isArea = true, parentField = "fundProvince")
    @Schema(description ="公积金缴纳地-市")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市")
    private String fundCity;

    /**
     * 公积金缴纳地-县
     */
    @ExcelAttribute(name = "公积金缴纳地-县",isArea = true, parentField = "fundCity")
    @Schema(description ="公积金缴纳地-县")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县")
    private String fundTown;

    /**
     * 社保缴纳地-省
     */
    @ExcelAttribute(name = "社保缴纳地-省",isArea = true)
    @Schema(description ="社保缴纳地-省")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省")
    private String socialProvince;

    /**
     * 社保缴纳地-市
     */
    @ExcelAttribute(name = "社保缴纳地-市", isArea = true, parentField = "socialProvince")
    @Schema(description ="社保缴纳地-市")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市")
    private String socialCity;

    /**
     * 社保缴纳地-县
     */
    @ExcelAttribute(name = "社保缴纳地-县", isArea = true, parentField = "socialCity")
    @Schema(description ="社保缴纳地-县")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县")
    private String socialTown;

    /**
     * 社保ID
     */
    @ExcelAttribute(name = "社保ID" )
    @Schema(description ="社保ID")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保ID")
    private String socialId;

    /**
     * 公积金ID
     */
    @ExcelAttribute(name = "公积金ID" )
    @Schema(description ="公积金ID")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金ID")
    private String fundId;

    /**
     * 社保合计
     */
    @ExcelAttribute(name = "社保合计" )
    @Schema(description ="社保合计")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保合计")
    private BigDecimal socialSum;

    /**
     * 单位社保合计
     */
    @ExcelAttribute(name = "单位社保合计" )
    @Schema(description ="单位社保合计")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
    private BigDecimal unitSocialSum;

    /**
     * 个人社保合计
     */
    @ExcelAttribute(name = "个人社保合计" )
    @Schema(description ="个人社保合计")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
    private BigDecimal socialSecurityPersonalSum;

    /**
     * 公积金总合计
     */
    @ExcelAttribute(name = "公积金总合计" )
    @Schema(description ="公积金总合计")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金总合计")
    private BigDecimal providentSum;

    /**
     * 就职班组
     */
    @ExcelAttribute(name = "就职班组" )
    @Schema(description ="就职班组")
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("就职班组")
    private String inauguralTeam;

	/**
	 * 推送状态
	 */
	@ExcelAttribute(name = "推送状态 0已推送 1未推送" )
	@Schema(description ="推送状态 0已推送 1未推送")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("推送状态 0已推送 1未推送")
	private String pushStatus;

	/**
	 * 收入状态
	 */
	@ExcelAttribute(name = "收入状态 0已生成 1未生成" )
	@Schema(description ="收入状态 0已生成 1未生成")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入状态 0已生成 1未生成")
	private String incomeStatus;

	/**
	 * 单位社保补缴利息
	 */
	@ExcelAttribute(name = "单位社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保补缴利息")
	private BigDecimal companyAccrual;
	/**
	 * 个人社保补缴利息
	 */
	@ExcelAttribute(name = "个人社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保补缴利息")
	private BigDecimal personalAccrual;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数")
	private BigDecimal unitPensionSet;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数")
	private BigDecimal unitUnemploymentSet;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数")
	private BigDecimal unitMedicalSet;
	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数")
	private BigDecimal unitInjurySet;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数")
	private BigDecimal unitBirthSet;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPensionPer;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPer;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPer;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitInjuryPer;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPer;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPensionPer;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPer;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPer;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal unitBigailmentPer;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal personalBigailmentPer;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额")
	private BigDecimal unitPensionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额")
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业金额
	 */
	@ExcelAttribute(name = "单位失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业金额")
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额")
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额")
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病金额
	 */
	@ExcelAttribute(name = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额")
	private BigDecimal unitBigmailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额")
	private BigDecimal personalPensionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额")
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal personalBigmailmentMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 公积金编号
	 */
	@ExcelAttribute(name = "公积金编号", maxLength = 20)
	@Size(max = 20, message = "公积金编号不可超过20位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金编号")
	private String providentNo;
	/**
	 * 单位公积金基数
	 */
	@ExcelAttribute(name = "单位公积金基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitProvidentSet;
	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal providentPercent;
	/**
	 * 单位公积金费用
	 */
	@ExcelAttribute(name = "单位公积金费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金费用")
	private BigDecimal unitProvidentSum;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalProidentSet;
	/**
	 * 个人公积金比例
	 */
	@ExcelAttribute(name = "个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalProvidentPercent;
	/**
	 * 个人公积金费用
	 */
	@ExcelAttribute(name = "个人公积金费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金费用")
	private BigDecimal personalProvidentSum;

	/**
	 * 工资社保结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@ExcelAttribute(name = "工资社保结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资社保结算状态")
	private String salarySocialFlag;
	/**
	 * 工资公积金结算状态  0: 未结算  1: 待结算  2: 已结算
	 */
	@ExcelAttribute(name = "工资公积金结算状态", maxLength = 1,isDataId = true,dataType = "settlement_flag")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资公积金结算状态")
	private String salaryFundFlag;

	/**
	 * 收入信息结算状态 0 已结算 1 结算中 2 未结算 3 已冻结
	 */
	@ExcelAttribute(name = "收入信息结算状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入信息结算状态")
	private String incomeSettleFlag;

	/**
	 * 收入信息结算状态 0 已收 1 未收 2 垫付
	 */
	@ExcelAttribute(name = "收入信息收款状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("收入信息收款状态")
	private String incomeCollectFlag;

	/**
	 * 支出信息结算状态 0 已结算 1 结算中 2 未结算
	 */
	@ExcelAttribute(name = "支出信息结算状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("支出信息结算状态")
	private String paySettleFlag;

	/**
	 * 支出信息付款状态 0 已付 1 未付
	 */
	@ExcelAttribute(name = "支出信息付款状态", maxLength = 2)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("支出信息付款状态")
	private String payCollectFlag;

	/**
	 * 二级指标归属
	 */
	@ExcelAttribute(name = "二级指标归属", maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("二级指标归属")
	@Schema(description = "二级指标归属")
	private String secondIndicatorBelong ;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;

	/**
	 * 是否需要生成收入
	 */
	@Schema(description ="是否需要生成收入 0需要 1不需要")
	@ExcelIgnore
	private String isIncomeStatus;

	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String ylSameFlg;
	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String dbSameFlg;
	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String sySameFlg;
	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String brSameFlg;
	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String gsSameFlg;
	/**
	 * 是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String ybSameFlg;
	/**
	 * 补缴是否导入重复标识
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String bjSameFlg;

	/**
	 * B端按年查询专用
	 */
	@TableField(exist = false)
	@ExcelIgnore
	private String likeYear;

}
