/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 *
 * @author huyc
 * @date 2023-07-18 11:38:05
 */
@Data
public class TDispatchSocialExportVo implements Serializable {

	/**
	 * 序号
	 */
	@Schema(description = "序号" )
	@ExcelAttribute(name = "序号" )
	@ExcelProperty("序号")
	private Integer num;
	/**
	 * 员工姓名
	 */
	@Schema(description = "姓名" )
	@ExcelAttribute(name = "姓名" )
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证件类型
	 */
	@Schema(description = "身份证件类型" )
	@ExcelAttribute(name = "身份证件类型" )
	@ExcelProperty("身份证件类型")
	private String idcardType;
	/**
	 * 身份证号
	 */
	@Schema(description = "身份证件号码" )
	@ExcelAttribute(name = "身份证件号码" )
	@ExcelProperty("身份证件号码")
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@Schema(description = "参保/停保时间" )
	@ExcelAttribute(name = "参保/停保时间" )
	@ExcelProperty("参保/停保时间")
	private String disMonth;

	/**
	 * 申报工资（元）
	 */
	@Schema(description = "申报工资（元）" )
	@ExcelAttribute(name = "申报工资（元）" )
	@ExcelProperty("申报工资（元）")
	private BigDecimal medicalCardinal;

	/**
	 * 新增
	 */
	@Schema(description = "新增" )
	@ExcelAttribute(name = "新增" )
	@ExcelProperty("新增")
	private String changeTypeOne;

	/**
	 * 续保
	 */
	@Schema(description = "续保" )
	@ExcelAttribute(name = "续保" )
	@ExcelProperty("续保")
	private String changeTypeTwo;

	/**
	 * 中断
	 */
	@Schema(description = "中断" )
	@ExcelAttribute(name = "中断" )
	@ExcelProperty("中断")
	private String changeTypeThree;

	/**
	 * 终止
	 */
	@Schema(description = "终止" )
	@ExcelAttribute(name = "终止" )
	@ExcelProperty("终止")
	private String changeTypeFour;

	/**
	 * 手机号码
	 */
	@Schema(description = "手机号码" )
	@ExcelAttribute(name = "手机号码" )
	@ExcelProperty("手机号码")
	private String empMobile;

	/**
	 * 学历
	 */
	@Schema(description = "学历")
	@ExcelAttribute(name = "学历" )
	@ExcelProperty("学历")
	private String educationName;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	@ExcelAttribute(name = "备注" )
	@ExcelProperty("备注")
	private String remark;
}
