/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSendEkpError;
import com.yifu.cloud.plus.v1.yifu.social.mapper.TSendEkpErrorMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.TSendEkpErrorService;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

/**
 * 收入明细表
 *
 * @author hgw
 * @date 2022-08-30 17:34:58
 */
@Log4j2
@Service
public class TSendEkpErrorServiceImpl extends ServiceImpl<TSendEkpErrorMapper, TSendEkpError> implements TSendEkpErrorService {

	/**
	 * @Description: 新增-推送ekp报错的记录表；
	 * @Author: hgw
	 * @Date: 2022/8/31 16:34
	 * @return: boolean
	 **/
	@Override
	public boolean saveError(TSendEkpError tSendEkpError) {
		// 类型、创建日不可为空
		if (Common.isEmpty(tSendEkpError.getType()) || Common.isEmpty(tSendEkpError.getCreateDay())) {
			return false;
		}
		TSendEkpError error = baseMapper.getByTitleTypeDay(tSendEkpError);
		if (error == null) {
			return this.save(tSendEkpError);
		} else {
			if (Common.isEmpty(tSendEkpError.getNums())) {
				tSendEkpError.setNums(CommonConstants.ONE_INT);
			}
			error.setNums(error.getNums() + tSendEkpError.getNums());
			return this.updateById(error);
		}
	}

}
