/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.csp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 入离职等的操作日志
 *
 * @author hgw
 * @date 2025-02-28 15:18:43
 */
@Data
@TableName("t_operation_log")
@Schema(description = "入离职等的操作日志")
public class TOperationLog {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 关联ID
	 */
	@ExcelAttribute(name = "关联ID", isNotEmpty = true, errorInfo = "关联ID不能为空", maxLength = 32)
	@NotBlank(message = "关联ID不能为空")
	@Length(max = 32, message = "关联ID不能超过32个字符")
	@ExcelProperty("关联ID")
	@Schema(description = "关联ID")
	private String mainId;
	/**
	 * 类型0入离职登记
	 */
	@ExcelAttribute(name = "类型0入离职登记", isNotEmpty = true, errorInfo = "类型0入离职登记不能为空", maxLength = 1)
	@NotBlank(message = "类型0入离职登记不能为空")
	@Length(max = 1, message = "类型0入离职登记不能超过1个字符")
	@ExcelProperty("类型0入离职登记")
	@Schema(description = "类型0入离职登记")
	private String type;
	/**
	 * 标题
	 */
	@ExcelAttribute(name = "标题", isNotEmpty = true, errorInfo = "标题不能为空", maxLength = 20)
	@NotBlank(message = "标题不能为空")
	@Length(max = 20, message = "标题不能超过20个字符")
	@ExcelProperty("标题")
	@Schema(description = "标题")
	private String title;
	/**
	 * 操作时间（档案里的入离职时间）
	 */
	@ExcelAttribute(name = "操作时间（档案里的入离职时间）", isNotEmpty = true, errorInfo = "操作时间（档案里的入离职时间）不能为空", isDate = true)
	@NotBlank(message = "操作时间（档案里的入离职时间）不能为空")
	@ExcelProperty("操作时间（档案里的入离职时间）")
	@Schema(description = "操作时间（档案里的入离职时间）")
	private LocalDateTime operationTime;
	/**
	 * 操作人姓名（档案里的人）
	 */
	@ExcelAttribute(name = "操作人姓名（档案里的人）", isNotEmpty = true, errorInfo = "操作人姓名（档案里的人）不能为空", maxLength = 20)
	@NotBlank(message = "操作人姓名（档案里的人）不能为空")
	@Length(max = 20, message = "操作人姓名（档案里的人）不能超过20个字符")
	@ExcelProperty("操作人姓名（档案里的人）")
	@Schema(description = "操作人姓名（档案里的人）")
	private String operationName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;
	/**
	 * 创建人
	 */
	@ExcelAttribute(name = "创建人", maxLength = 64)
	@Length(max = 64, message = "创建人不能超过64个字符")
	@ExcelProperty("创建人")
	@Schema(description = "创建人")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Length(max = 32, message = "创建人姓名不能超过32个字符")
	@ExcelProperty("创建人姓名")
	@Schema(description = "创建人姓名")
	private String createName;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 50)
	@Length(max = 50, message = "备注不能超过50个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

}
