package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchasePersonAddVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 含风险项目不购买申请表
 *
 * @author huych
 * @date 2025-01-10 11:24:38
 */
@Data
@TableName("t_insurance_unpurchase_apply")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "含风险项目不购买申请表")
public class TInsuranceUnpurchaseApply extends BaseEntity {

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	@Schema(description = "项目ID")
	private String deptId;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "申请人所在部门")
	private String createUserDeptId;

	@Schema(description = "申请人所在部门名称")
	private String createUserDeptName;

	@Schema(description = "不购买原因 1 已购买社保 2 人员已离职")
	private String reasonType;

	@Schema(description = "原因说明")
	private String reasonInfo;

	@Schema(description = "申请编号")
	private String applyNo;

	@Schema(description = "项目是否有审批通过记录 0 是 1 否")
	private String auditFlag;

	@Schema(description = "申请人是否属于子分公司 0 是 1 否")
	private String companyFlag;

	@Schema(description = "是否删除 0未删除/1删除")
	@TableLogic
	private String deleteFlag;

	@Schema(description = "申请状态 0 草稿 1待提交 2 待审核 3 审核通过 4 审核不通过")
	private String status;

	@Schema(description ="是否含风险 0 是 1 否")
	private String hasContainRisks;

	@Schema(description ="事业部条线")
	private String newLine;

	@Schema(description ="事业部")
	private String division;

	@Schema(description ="服务项是否勾选商险 0 是 1 否")
	private String insuranceFlag;

	@Schema(description ="当前审核人")
	private String auditUser;

	@Schema(description ="当前审核人ID")
	private String auditUserId;

	@Schema(description ="不购买人数")
	private String unbuyNum;

	/**
	 * 创建时间 暂存不存创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	private LocalDateTime createTimeZc;

	@Schema(description ="明细数据集")
	@TableField(exist = false)
	private List<TInsuranceUnpurchasePersonAddVo> personList;

	/**
	 * 附件Id
	 */
	@TableField(exist = false)
	private List<String> attaIdList;

	/**
	 * 暂存，提交区分
	 */
	@TableField(exist = false)
	private String saveFlag;

	/**
	 * 详情就职岗位和人数
	 */
	@TableField(exist = false)
	private Map<String,Long> personMap;

	/**
	 * 印章附件
	 */
	@TableField(exist = false)
	private List<TSalaryAtta> attaInfoList;
}
