package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 社保待购买表
 *
 * @author huych
 * @date 2025-09-30 16:40:07
 */
@Data
@TableName("t_dispatch_info_pre")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保待购买表")
public class TDispatchInfoPre extends BaseEntity {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("ID")
	@Schema(description = "ID")
	private String id;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败
	 */
	@ExcelAttribute(name = "社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败", maxLength = 2)
	@Length(max = 2, message = "社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败不能超过2个字符")
	@ExcelProperty("社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败")
	@Schema(description = "社保购买状态，0待确认，1待派单，2派单失败，3待审核，4审核不通过，5待办理，6办理中，7办理成功，8办理失败，9部分办理失败")
	private String processStatus;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Length(max = 32, message = "项目id不能超过32个字符")
	@ExcelProperty("项目id")
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 社保缴纳地-省
	 */
	@ExcelAttribute(name = "社保缴纳地-省", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-省不能超过32个字符")
	@ExcelProperty("社保缴纳地-省")
	@Schema(description = "社保缴纳地-省")
	private String socialProvince;
	/**
	 * 社保缴纳地-市
	 */
	@ExcelAttribute(name = "社保缴纳地-市", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-市不能超过32个字符")
	@ExcelProperty("社保缴纳地-市")
	@Schema(description = "社保缴纳地-市")
	private String socialCity;
	/**
	 * 社保缴纳地-县
	 */
	@ExcelAttribute(name = "社保缴纳地-县", maxLength = 32)
	@Length(max = 32, message = "社保缴纳地-县不能超过32个字符")
	@ExcelProperty("社保缴纳地-县")
	@Schema(description = "社保缴纳地-县")
	private String socialTown;
	/**
	 * 公积金缴纳地-省
	 */
	@ExcelAttribute(name = "公积金缴纳地-省", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-省不能超过32个字符")
	@ExcelProperty("公积金缴纳地-省")
	@Schema(description = "公积金缴纳地-省")
	private String fundProvince;
	/**
	 * 公积金缴纳地-市
	 */
	@ExcelAttribute(name = "公积金缴纳地-市", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-市不能超过32个字符")
	@ExcelProperty("公积金缴纳地-市")
	@Schema(description = "公积金缴纳地-市")
	private String fundCity;
	/**
	 * 公积金缴纳地-县
	 */
	@ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32)
	@Length(max = 32, message = "公积金缴纳地-县不能超过32个字符")
	@ExcelProperty("公积金缴纳地-县")
	@Schema(description = "公积金缴纳地-县")
	private String fundTown;
	/**
	 * 派单项：如 养老、公积金
	 */
	@ExcelAttribute(name = "派单项：如 养老、公积金", maxLength = 50)
	@Length(max = 50, message = "派单项：如 养老、公积金不能超过50个字符")
	@ExcelProperty("派单项：如 养老、公积金")
	@Schema(description = "派单项：如 养老、公积金")
	private String dispatchItem;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 公积金户名称
	 */
	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Length(max = 50, message = "公积金户不能超过50个字符")
	@ExcelProperty("公积金户")
	@Schema(description = "公积金户")
	private String providentHouseholdName;
	/**
	 * 社保户名称
	 */
	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Length(max = 50, message = "社保户不能超过50个字符")
	@ExcelProperty("社保户")
	@Schema(description = "社保户")
	private String socialHouseholdName;
	/**
	 * 0社保1公积金
	 */
	@ExcelAttribute(name = "0社保1公积金", maxLength = 1)
	@Length(max = 1, message = "0社保1公积金不能超过1个字符")
	@ExcelProperty("0社保1公积金")
	@Schema(description = "0社保1公积金")
	private String typeSub;
	/**
	 * 备案基数
	 */
	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Length(max = 255, message = "备案基数不能超过255个字符")
	@ExcelProperty("备案基数")
	@Schema(description = "备案基数")
	private String recordBase;
	/**
	 * 备案基数类型 0固定值 1自定义
	 */
	@ExcelAttribute(name = "备案基数类型 0固定值 1自定义", maxLength = 1)
	@Length(max = 1, message = "备案基数类型 0固定值 1自定义不能超过1个字符")
	@ExcelProperty("备案基数类型 0固定值 1自定义")
	@Schema(description = "备案基数类型 0固定值 1自定义")
	private String recordBaseType;
	/**
	 * 入职日期
	 */
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	@Schema(description = "入职日期")
	private Date joinLeaveDate;
	/**
	 * 前端客服姓名
	 */
	@ExcelAttribute(name = "前端客服", maxLength = 30)
	@Length(max = 30, message = "前端客服不能超过30个字符")
	@ExcelProperty("前端客服")
	@Schema(description = "前端客服")
	private String customerUsername;
	/**
	 * 前端客服登录名
	 */
	@ExcelAttribute(name = "前端客服登录名")
	@Schema(description = "前端客服登录名")
	@ExcelProperty("前端客服登录名")
	private String customerUserLoginName;
	/**
	 * 预计派单时间
	 */
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	@Schema(description = "预计派单时间")
	private LocalDateTime expectedCollectionTime;
	/**
	 * 派单确认时间
	 */
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
	@Schema(description = "派单确认时间")
	private LocalDateTime expectedConfirmTime;
	/**
	 * 是否自动触发派增 0 是 1否
	 */
	@ExcelAttribute(name = "是否自动触发派增 0 是 1否", maxLength = 1)
	@Length(max = 1, message = "是否自动触发派增 0 是 1否不能超过1个字符")
	@ExcelProperty("是否自动触发派增 0 是 1否")
	@Schema(description = "是否自动触发派增 0 是 1否")
	private String isAutoDis;
	/**
	 * 起缴日期是否一致 0 是 1否
	 */
	@ExcelAttribute(name = "起缴日期是否一致 0 是 1否", maxLength = 1)
	@Length(max = 1, message = "起缴日期是否一致 0 是 1否不能超过1个字符")
	@ExcelProperty("起缴日期是否一致 0 是 1否")
	@Schema(description = "起缴日期是否一致 0 是 1否")
	private String isCreateDate;
	/**
	 * 起缴日期
	 */
	@ExcelAttribute(name = "起缴日期", isDate = true)
	@Schema(description = "起缴日期")
	@ExcelProperty("起缴日期")
	private Date socialStartDate;
	/**
	 * 配置名称
	 */
	@ExcelAttribute(name = "配置名称", maxLength = 50)
	@Length(max = 50, message = "配置名称不能超过50个字符")
	@ExcelProperty("配置名称")
	@Schema(description = "配置名称")
	private String configName;
	/**
	 * 配置id
	 */
	@ExcelAttribute(name = "配置id")
	@Schema(description = "配置id")
	@ExcelProperty("配置id")
	private String configId;
	/**
	 * 接收方式
	 */
	@Schema(description = "接收方式 0项目配置 1自定义")
	private String receiveType;
	/**
	 * 入职确认信息主表id
	 */
	@ExcelAttribute(name = "入职确认信息主表id", maxLength = 36)
	@Length(max = 36, message = "入职确认信息主表id不能超过36个字符")
	@ExcelProperty("入职确认信息主表id")
	@Schema(description = "入职确认信息主表id")
	private String registerId;
	/**
	 * 养老起缴日期
	 */
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@ExcelProperty("养老起缴日期")
	@Schema(description = "养老起缴日期")
	private Date pensionStart;
	/**
	 * 医疗起缴日期
	 */
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@ExcelProperty("医疗起缴日期")
	@Schema(description = "医疗起缴日期")
	private Date medicalStart;
	/**
	 * 失业起缴日期
	 */
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@ExcelProperty("失业起缴日期")
	@Schema(description = "失业起缴日期")
	private Date unemployStart;
	/**
	 * 工伤起缴日期
	 */
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@ExcelProperty("工伤起缴日期")
	@Schema(description = "工伤起缴日期")
	private Date workInjuryStart;
	/**
	 * 生育起缴日期
	 */
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@ExcelProperty("生育起缴日期")
	@Schema(description = "生育起缴日期")
	private Date birthStart;
	/**
	 * 大病起缴日期
	 */
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@ExcelProperty("大病起缴日期")
	@Schema(description = "大病起缴日期")
	private Date bigailmentStart;
	/**
	 * 委托备注
	 */
	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Length(max = 100, message = "委托备注不能超过100个字符")
	@ExcelProperty("委托备注")
	@Schema(description = "委托备注")
	private String trustRemark;
	/**
	 * 养老基数
	 */
	@ExcelAttribute(name = "养老基数")
	@ExcelProperty("养老基数")
	@Schema(description = "养老基数")
	private BigDecimal pensionCardinal;
	/**
	 * 医疗基数
	 */
	@ExcelAttribute(name = "医疗基数")
	@ExcelProperty("医疗基数")
	@Schema(description = "医疗基数")
	private BigDecimal medicalCardinal;
	/**
	 * 失业基数
	 */
	@ExcelAttribute(name = "失业基数")
	@ExcelProperty("失业基数")
	@Schema(description = "失业基数")
	private BigDecimal unemploymentCardinal;
	/**
	 * 大病救助基数
	 */
	@ExcelAttribute(name = "大病救助基数")
	@ExcelProperty("大病救助基数")
	@Schema(description = "大病救助基数")
	private BigDecimal bigailmentCardinal;
	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数")
	@ExcelProperty("工伤基数")
	@Schema(description = "工伤基数")
	private BigDecimal workInjuryCardinal;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数")
	@ExcelProperty("生育基数")
	@Schema(description = "生育基数")
	private BigDecimal birthCardinal;
	/**
	 * 缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）
	 */
	@ExcelAttribute(name = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）", maxLength = 1)
	@Length(max = 1, message = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）不能超过1个字符")
	@ExcelProperty("缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）")
	@Schema(description = "缴纳类型（0最低缴纳、1自定义缴纳、2最高缴纳）")
	private String paymentType;
	/**
	 * 合同签署状态 0已签署 1未签署
	 */
	@ExcelAttribute(name = "合同签署状态 0已签署 1未签署", maxLength = 1)
	@Length(max = 1, message = "合同签署状态 0已签署 1未签署不能超过1个字符")
	@ExcelProperty("合同签署状态 0已签署 1未签署")
	@Schema(description = "合同签署状态 0已签署 1未签署")
	private String contractStatus;
	/**
	 * 合同id
	 */
	@ExcelAttribute(name = "合同id")
	@ExcelProperty("合同id")
	@Schema(description = "合同id")
	private String contractId;

	/**
	 * 派单id
	 */
	@ExcelAttribute(name = "派单id")
	@ExcelProperty("派单id")
	@Schema(description = "派单id")
	private String dispatcherId;

	@Schema(description = "发起失败原因")
	private String errorInfo;

	@Schema(description = "发起失败时间")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Date errorTime;

	@Schema(description = "派单审核/办理不通过原因")
	private String errorBackInfo;

	/**
	 * 0未删除1删除
	 */
	@ExcelAttribute(name = "0未删除1删除", maxLength = 1)
	@Length(max = 1, message = "0未删除1删除不能超过1个字符")
	@ExcelProperty("0未删除1删除")
	@Schema(description = "0未删除1删除")
	private String deleteFlag;

	/**
	 * 就职岗位
	 */
	@Length(max = 50, message = "就职岗位 不能超过50 个字符")
	@ExcelAttribute(name = "就职岗位", maxLength = 50)
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

}
