/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 人员档案表excel导出对应的实体
 *
 * @author hgw
 * @date 2022-6-24 15:15:24
 */
@Data
@ColumnWidth(10)
public class EmployeeLeaveExportVO  {

	private static final long serialVersionUID = 1L;


	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工主码")
	private String empCode;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;

	@ColumnWidth(20)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	private String empIdcard;


	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "手机号码")
	private String empPhone;

	@ExcelAttribute(name = "档案所在省", isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在省")
	private String fileProvince;

	@ExcelAttribute(name = "档案所在市", isArea = true, parentField = "fileProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在市")
	private String fileCity;

	@ExcelAttribute(name = "档案所在县", isArea = true, parentField = "fileCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在县")
	private String fileTown;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位名称")
	private String unitName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目名称")
	private String deptName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码")
	private String deptNo;

	@ExcelAttribute(name = "员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工类型")
	private String empNatrue;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档人")
	private String leaveUserName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "减档时间")
	private LocalDateTime leaveTime;



}
