/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import java.io.Serializable;

/**
 * 导入-瓜子offer信息接收表
 *
 * @author hgw
 * @date 2025-6-16 17:37:47
 */
@Data
public class TGzOfferInfoImportVo extends RowIndex implements Serializable {

	// 序号	offer发放人	录入时间	姓名	姓名拼音	证件类型描述	证件号码	性别	个人手机号	个人邮箱

	// 无用的3个字段
	@ExcelAttribute(name = "序号")
	private String noUse1;
	@ExcelAttribute(name = "offer发放人")
	private String noUse2;
	@ExcelAttribute(name = "录入时间")
	private String noUse3;

	@ExcelAttribute(name = "姓名", maxLength = 50)
	private String name;
	@ExcelAttribute(name = "姓名拼音", maxLength = 100)
	private String nameAc;

	// 1A ——不导入 证件类型编码
	// 居民身份证
	@ExcelAttribute(name = "证件类型描述", maxLength = 30)
	private String nationalIdTypeDescr;

	@ExcelAttribute(name = "证件号码", maxLength = 50)
	private String nationalId;
	// F（女）
	// M（男）
	@ExcelAttribute(name = "性别", maxLength = 10)
	private String sex;
	@ExcelAttribute(name = "个人手机号", maxLength = 30)
	private String phone;
	@ExcelAttribute(name = "个人邮箱", maxLength = 100)
	private String email;

	// 预计入职日期	部门名称	职务描述	直接上级姓名	工作地点描述	社保缴纳地	基本工资	绩效工资	年终奖月数
	// 要翻译为这个
	@ExcelAttribute(name = "预计入职日期")
	private String expEntry;
	@ExcelAttribute(name = "部门名称", maxLength = 200)
	private String deptName;
	@ExcelAttribute(name = "职务描述", maxLength = 50)
	private String jobcodeDescr;
	@ExcelAttribute(name = "直接上级姓名", maxLength = 200)
	private String supervisorName;

	// 要翻译工作地点描述——34010001 安徽省合肥市电销中心——34010002 安徽省合肥市区域
	@ExcelAttribute(name = "工作地点描述", maxLength = 12)
	private String workLocationDescr;

	@ExcelAttribute(name = "社保缴纳地", maxLength = 30)
	private String socialInsuranceLocationDescr;
	/**
	 * 基本工资,两位小数
	 */
	@ExcelAttribute(name = "基本工资")
	private String basePay;
	/**
	 * 绩效工资,两位小数
	 */
	@ExcelAttribute(name = "绩效工资")
	private String perfomPay;
	// 年终奖月数数字——去除“个月”
	@ExcelAttribute(name = "年终奖月数")
	private String yearBonus;

}
