package com.yifu.cloud.plus.v1.business.mapper.salary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfig;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * B端-薪资配置
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Mapper
public interface TBusSalaryConfigMapper extends BaseMapper<TBusSalaryConfig> {
     /**
      * B端-薪资配置简单分页查询
      *
      * @param tBusSalaryConfig B端-薪资配置
      * @return
      */
     IPage<TBusSalaryConfig> getTBusSalaryConfigPage(Page<TBusSalaryConfig> page, @Param("tBusSalaryConfig") TBusSalaryConfig tBusSalaryConfig);

     List<TBusSalaryConfig> getConfigList();

     /**
      * @Description: 获取必要列的list
      * @Author: hgw
      * @Date: 2021/9/10 14:52
      * @return: java.util.List<java.lang.String>
      **/
     List<String> getMustList();

}
