package com.yifu.cloud.plus.v1.yifu.order.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 订单表 t_order
 * @date 2022-08-26 17:20:16
 */
@Data
@TableName("t_order")
@Schema(description = "订单表")
public class TOrder implements Serializable {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 订单编号
     */
	@Schema(description = "订单编号")
    private String orderNo;

    /**
     * 客户名称
     */
	@Schema(description = "客户名称")
    private String customerName;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String deptId;

    /**
     * 项目名称
     */
	@Schema(description = "项目名称")
    private String deptName;

    /**
     * 项目编码
     */
	@Schema(description = "项目编码")
    private String deptNo;

    /**
     * 订单状态 0待办理 1办理中 2已办结
     */
	@Schema(description = "订单状态 0待办理 1办理中 2已办结")
    private Integer orderStatus;

    /**
     * 订单内容
     */
	@Schema(description = "订单内容")
    private String orderContent;

    /**
     * 创建人姓名（下单人）
     */
	@Schema(description = "创建人姓名（下单人）")
    private String createName;

    /**
     * 创建时间（下单时间）
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间（下单时间）")
    private LocalDateTime createTime;

    /**
     * 更新人
     */
	@Schema(description = "更新人")
    private String updateBy;

    /**
     * 更新人姓名
     */
	@Schema(description = "更新人姓名")
    private String updateName;

    /**
     * 更新时间
     */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "更新时间")
	@TableField(fill = FieldFill.UPDATE)
    private LocalDateTime updateTime;

    /**
     * 是否删除 0未删除/1删除
     */
	@Schema(description = "是否删除 0未删除/1删除")
    private Integer deleteFlag;

    private static final long serialVersionUID = 1L;

	/**
	 * 星级
	 */
	@Schema(description = "星级")
	private String level;


	/**
	 * 下单人所在部门
	 */
	@Schema(description = "下单人所在部门")
	private String department;


	/**
	 * 客户等级
	 */
	@Schema(description = "客户等级")
	private String customerGrade;

	/**
	 * 紧急程度
	 */
	@Schema(description = "紧急程度")
	private String urgencyExtent;

	/**
	 * 服务类型
	 */
	@Schema(description = "服务类型")
	private String serviceType;

	/**
	 * 服务项目
	 */
	@Schema(description = "服务项目")
	private String serviceProject;

	/**
	 * 其他支撑需求
	 */
	@Schema(description = "其他支撑需求")
	private String demand;

	/**
	 * 指派人
	 */
	@Schema(description = "指派人")
	private String handleUser;

	/**
	 * 待客户确认后提交审核
	 */
	@Schema(description = "待客户确认后提交审核")
	private String status;


	/**
	 * 工资暂时停发
	 */
	@Schema(description = "工资暂时停发")
	private String wageFlag;

	/**
	 * 工资姓名
	 */
	@Schema(description = "工资姓名")
	private String wageName;

	/**
	 * 工资身份证号
	 */
	@Schema(description = "工资身份证号")
	private String wageIdcard;

	/**
	 * 工资费用
	 */
	@Schema(description = "工资费用")
	private String wageExpenses;

	/**
	 * 费用调整_薪资
	 */
	@Schema(description = "费用调整_薪资")
	private String salaryFlag;

	/**
	 * 薪资姓名
	 */
	@Schema(description = "薪资姓名")
	private String salaryName;

	/**
	 * 薪资身份证号
	 */
	@Schema(description = "薪资身份证号")
	private String salaryIdcard;

	/**
	 * 薪资费用
	 */
	@Schema(description = "薪资费用")
	private String salaryExpenses;

	/**
	 * 费用调整_社保
	 */
	@Schema(description = "费用调整_社保")
	private String socialFlag;

	/**
	 * 社保姓名
	 */
	@Schema(description = "社保姓名")
	private String socialName;

	/**
	 * 社保身份证号
	 */
	@Schema(description = "社保身份证号")
	private String socialIdcard;

	/**
	 * 社保费用
	 */
	@Schema(description = "社保费用")
	private String socialExpenses;

	/**
	 * 费用调整_公积金
	 */
	@Schema(description = "费用调整_公积金")
	private String fundFlag;

	/**
	 * 公积金姓名
	 */
	@Schema(description = "公积金姓名")
	private String fundName;

	/**
	 * 公积金身份证号
	 */
	@Schema(description = "公积金身份证号")
	private String fundIdcard;

	/**
	 * 公积金费用
	 */
	@Schema(description = "公积金费用")
	private String fundExpenses;

	/**
	 * 费用调整_商险
	 */
	@Schema(description = "费用调整_商险")
	private String insuranceFlag;

	/**
	 * 商险姓名
	 */
	@Schema(description = "商险姓名")
	private String insuranceName;

	/**
	 * 商险身份证号
	 */
	@Schema(description = "商险身份证号")
	private String insuranceIdcard;

	/**
	 * 商险费用
	 */
	@Schema(description = "商险费用")
	private String insuranceExpenses;

	/**
	 * 费用代扣
	 */
	@Schema(description = "代扣")
	private String withholdingFlag;

	/**
	 * 代扣名称
	 */
	@Schema(description = "代扣名称")
	private String withholdingName;

	/**
	 * 代扣身份证号
	 */
	@Schema(description = "代扣身份证号")
	private String withholdingIdcard;

	/**
	 * 代扣费用
	 */
	@Schema(description = "代扣费用")
	private String withholdingExpenses;

	/**
	 * 费用代收
	 */
	@Schema(description = "费用代收")
	private String collectionFlag;

	/**
	 * 代收姓名
	 */
	@Schema(description = "代收姓名")
	private String collectionName;

	/**
	 * 代收身份证号
	 */
	@Schema(description = "代收身份证号")
	private String collectionIdcard;

	/**
	 * 代收费用
	 */
	@Schema(description = "代收")
	private String collectionExpenses;

	/**
	 * 非扣税项
	 */
	@Schema(description = "非扣税项")
	private String noTaxFlag;

	/**
	 * 非扣税名称
	 */
	@Schema(description = "非扣税名称")
	private String noTaxName;

	/**
	 * 非扣税身份证号
	 */
	@Schema(description = "非扣税身份证号")
	private String noTaxIdcard;

	/**
	 * 非扣税费用
	 */
	@Schema(description = "非扣税费用")
	private String noTaxExpenses;

	/**
	 * 其他项
	 */
	@Schema(description = "其他项")
	private String otherFlag;

	/**
	 * 其他名称
	 */
	@Schema(description = "其他名称")
	private String otherName;

	/**
	 * 其他项身份证号
	 */
	@Schema(description = "其他项身份证号")
	private String otherIdcard;

	/**
	 * 其他项费用
	 */
	@Schema(description = "其他项费用")
	private String otherExpenses;

	/**
	 * 附件ID集合
	 */
	@Schema(description = "附件ID集合")
	private String   attIds;

}