package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.SysMessageSalary;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SysMessageSalaryExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.SysMessageSalarySearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 最低工资提醒-每月更新一次
 *
 * @author hgw
 * @date 2019-11-21 17:18:10
 */
@Mapper
public interface SysMessageSalaryMapper extends BaseMapper<SysMessageSalary> {
     /**
      * 最低工资提醒-每月更新一次简单分页查询
      *
      * @param sysMessageSalary 最低工资提醒-每月更新一次
      * @return
      */
     IPage<SysMessageSalary> getSysMessageSalaryPage(Page<SysMessageSalary> page, @Param("sysMessageSalary") SysMessageSalary sysMessageSalary, @Param("settleDomainVos") List<TSettleDomainSelectVo> settleDomainVos);


     IPage<SysMessageSalary> getSysMessageSalaryHandlePage(Page<SysMessageSalary> page, @Param("sysMessageSalary") SysMessageSalary sysMessageSalary);

     /**
      * @param settleMonth
      * @Description: 新增-普通工资
      * @Author: hgw
      * @Date: 2019/11/21 18:10
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.vo.SysMessageSalaryVo>
      **/
     List<SysMessageSalary> insertSalaryBySettleMonth(@Param("settleMonth") String settleMonth);

     /**
      * @param settleMonth
      * @Description: 新增-工程工资
      * @Author: hgw
      * @Date: 2019/11/21 18:10
      * @return: java.util.List<com.yifu.cloud.v1.hrms.api.vo.SysMessageSalaryVo>
      **/
     List<SysMessageSalary> insertEngineerBySettleMonth(@Param("settleMonth") String settleMonth);

     /**
      * @param settleMonth 结算月
      * @Description: 生成前，先删除老数据
      * @Author: hgw
      * @Date: 2019/11/21 17:28
      * @return: void
      **/
     void deleteAllBySettleMonth(@Param("settleMonth") String settleMonth);

    List<SysMessageSalaryExportVo> noPageDiy(@Param("sysMessageSalary")SysMessageSalarySearchVo searchVo,
											 @Param("settleDomainIds")List<String> settleDomains,
											 @Param("idsStr") List<String> idsStr,
											 @Param("sql")String sql);

	int noPageCountDiy(@Param("sysMessageSalary")SysMessageSalarySearchVo searchVo,
					   @Param("settleDomainIds")List<String> settleDomains,
					   @Param("idsStr") List<String> idsStr,
					   @Param("sql")String sql);
}
