/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.sentinel.dashboard.datasource.entity.rule;

import com.alibaba.csp.sentinel.slots.system.SystemRule;

import java.util.Date;

/**
 * @author leyou
 */
public class SystemRuleEntity implements RuleEntity {

	private Long id;

	private String app;

	private String ip;

	private Integer port;

	private Double highestSystemLoad;

	private Long avgRt;

	private Long maxThread;

	private Double qps;

	private Double highestCpuUsage;

	private Date gmtCreate;

	private Date gmtModified;

	public static SystemRuleEntity fromSystemRule(String app, String ip, Integer port, SystemRule rule) {
		SystemRuleEntity entity = new SystemRuleEntity();
		entity.setApp(app);
		entity.setIp(ip);
		entity.setPort(port);
		entity.setHighestSystemLoad(rule.getHighestSystemLoad());
		entity.setHighestCpuUsage(rule.getHighestCpuUsage());
		entity.setAvgRt(rule.getAvgRt());
		entity.setMaxThread(rule.getMaxThread());
		entity.setQps(rule.getQps());
		return entity;
	}

	@Override
	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	@Override
	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}

	@Override
	public Long getId() {
		return id;
	}

	@Override
	public void setId(Long id) {
		this.id = id;
	}

	@Override
	public String getApp() {
		return app;
	}

	public void setApp(String app) {
		this.app = app;
	}

	public Double getHighestSystemLoad() {
		return highestSystemLoad;
	}

	public void setHighestSystemLoad(Double highestSystemLoad) {
		this.highestSystemLoad = highestSystemLoad;
	}

	public Long getAvgRt() {
		return avgRt;
	}

	public void setAvgRt(Long avgRt) {
		this.avgRt = avgRt;
	}

	public Long getMaxThread() {
		return maxThread;
	}

	public void setMaxThread(Long maxThread) {
		this.maxThread = maxThread;
	}

	public Double getQps() {
		return qps;
	}

	public void setQps(Double qps) {
		this.qps = qps;
	}

	public Double getHighestCpuUsage() {
		return highestCpuUsage;
	}

	public void setHighestCpuUsage(Double highestCpuUsage) {
		this.highestCpuUsage = highestCpuUsage;
	}

	@Override
	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	@Override
	public SystemRule toRule() {
		SystemRule rule = new SystemRule();
		rule.setHighestSystemLoad(highestSystemLoad);
		rule.setAvgRt(avgRt);
		rule.setMaxThread(maxThread);
		rule.setQps(qps);
		rule.setHighestCpuUsage(highestCpuUsage);
		return rule;
	}

}
