/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

/**
 * 法大大合同附属信息表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_contract_attach_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大合同附属信息表")
public class FddContractAttachInfo extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 合同id
     */
    @Schema(description ="合同id")
	@ExcelAttribute(name = "合同id",  errorInfo = "员工合同id主键不能为空", maxLength = 32)
    private String contractId;

    /**
     * 合同试用期开始时间
     */
    @Schema(description ="合同试用期开始时间")
	@ExcelAttribute(name = "合同试用期开始时间")
    private LocalDate periodStart;

    /**
     * 合同试用期结束时间
     */
    @Schema(description ="合同试用期结束时间")
	@ExcelAttribute(name = "合同试用期结束时间")
    private LocalDate periodEnd;

    /**
     * 合同起始时间
     */
    @Schema(description ="合同起始时间")
	@ExcelAttribute(name = "合同起始时间", isNotEmpty = true, errorInfo = "合同起始时间不能为空")
	private Date contractStart;

    /**
     * 合同到期时间
     */
    @Schema(description ="合同到期时间")
	@ExcelAttribute(name = "合同到期时间", isNotEmpty = true, errorInfo = "合同到期时间不能为空")
	private Date contractEnd;

    /**
     * 试用期工资 元/月
     */
    @Schema(description ="试用期工资 元/月")
	@ExcelAttribute(name = "试用期工资")
	private BigDecimal periodSalaryPerMonth;

    /**
     * 工资形式 1.计时工资 2.计件工资 3.其他
     */
    @Schema(description ="工资形式 1.计时工资 2.计件工资 3.其他")
	@ExcelAttribute(name = "工资形式", isDataId = true, dataType = "salary_type")
    private String salaryType;

    /**
     * 计时工资 工资标准 元/月
     */
    @Schema(description ="计时工资 工资标准 元/月")
	@ExcelAttribute(name = "计时工资")
    private BigDecimal salaryStandardPerHour;

    /**
     * 计件工资 工资标准单价/元
     */
    @Schema(description ="计件工资 工资标准单价/元")
	@ExcelAttribute(name = "计件工资")
    private BigDecimal salaryStandardPerPiece;

    /**
     * 工作地点
     */
    @Schema(description ="工作地点")
	@Length(max=200,message = "工作地点不能超过200个字符")
	@ExcelAttribute(name = "工作地点",isNotEmpty = true, errorInfo = "工作地点不能为空", maxLength = 200 )
    private String workSpace;

    /**
     * 岗位
     */
    @Schema(description ="岗位")
	@Length(max = 20, message = "岗位不能超过20个字符")
	@ExcelAttribute(name = "岗位", isNotEmpty = true, errorInfo = "岗位不能为空", maxLength = 20, needExport = true)
    private String post;

    /**
     * 备注
     */
    @Schema(description ="备注")
    private String remark;

    /**
     * 是否删除 0未删除/1删除
     */
    @Schema(description ="是否删除 0未删除/1删除")
    private String deleteFlag;

    /**
     * 附件是否已转移到合同里（0：未转移；1已转移）
     */
    @Schema(description ="附件是否已转移到合同里（0：未转移；1已转移）")
    private Integer isMove;

    /**
     * 法大大模板id
     */
    @Schema(description ="法大大模板id")
	@ExcelAttribute(name = "法大大模板id")
	private String fddTemplateId;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32, needExport = true)
    private String empName;

    /**
     * 身份证号码
     */
    @Schema(description ="身份证号")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32, needExport = true)
	private String empIdcard;

    /**
     * 手机号码
     */
    @Schema(description ="手机号码")
	@ExcelAttribute(name = "手机号码", isNotEmpty = true, errorInfo = "手机号码不能为空", maxLength = 32, needExport = true)
	private String empPhone;

    /**
     * 项目编码
     */
    @Schema(description ="项目编码")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 20, needExport = true)
	private String departNo;

	/**
	 * 员工类型
	 */
	@Schema(description ="员工类型")
	@ExcelAttribute(name = "员工类型", isNotEmpty = true, errorInfo = "员工类型不能为空", isDataId = true, dataType = "emp_natrue",maxLength = 20, needExport = true)
	private String empNatrue;

	/**
	 * 项目名称
	 */
	@TableField(exist = false)
	@Schema(name = "项目名称")
	private String departName;
	/**
	 * 客户名称
	 */
	@TableField(exist = false)
	@Schema(name = "客户名称")
	private String customerName;


	/**
	 * 法大大电子合同id
	 */
	@TableField(exist = false)
	@Schema(description ="法大大电子合同id")
	private String fddContractId;

	/**
	 * 定稿状态 1未定稿 2.定稿成功
	 */
	@TableField(exist = false)
	@Schema(description ="定稿状态 1未定稿 2.定稿成功")
	private String taskStatus;
	/**
	 * 签署状态 1.未签署 2 已签署  4 已撤销 5已拒签
	 */
	@TableField(exist = false)
	@Schema(description ="签署状态 1.未签署 2 已签署  4 已撤销 5已拒签")
	private String signStatus;


	/**
	 * 签署发送方状态 1.未签署 2 已签署 3 已拒签 4 已撤销
	 */
	@TableField(exist = false)
	@Schema(description ="签署发送方状态 1.未签署 2 已签署 3 已拒签 4 已撤销")
	private String sendSignStatus;


	/**
	 * 签署接收方状态 1.未签署 2 已签署 3 已拒签 4 已撤销
	 */
	@TableField(exist = false)
	@Schema(description ="签署接收方状态 1.未签署 2 已签署 3 已拒签 4 已撤销")
	private String receiveSignStatus;


	/**
	 * 定稿任务编号
	 */
	@TableField(exist = false)
	@Schema(description ="定稿任务编号")
	private String taskId;
	/**
	 * 签署任务编号
	 */
	@TableField(exist = false)
	@Schema(description ="签署任务编号")
	private String signTaskId;

	/**
	 * 草稿id,用于生成后续签署任务
	 */
	@TableField(exist = false)
	@Schema(description ="草稿id,用于生成后续签署任务")
	private String draftId;
}
