package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * b端用户客户关系表
 *
 * @author pwang
 * @date 2020-08-26 12:00:12
 */
@Data
@TableName("m_setttle_customer_user")
@Tag(name = "b端用户客户关系表")
public class MSetttleCustomerUser {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键", name = "id")
    private String id;
    /**
     * 客户id
     */
    @NotBlank(message = "客户id不能为空")
    @Length(max = 32, message = "客户id不能超过32个字符")
    @ExcelAttribute(name = "客户id", isNotEmpty = true, errorInfo = "客户id不能为空", maxLength = 32)
    @Schema(description = "客户id", name = "customerId")
    private String customerId;
    /**
     * 结算主体id
     */
    @NotBlank(message = "结算主体id不能为空")
    @Length(max = 32, message = "结算主体id不能超过32个字符")
    @ExcelAttribute(name = "结算主体id", isNotEmpty = true, errorInfo = "结算主体id不能为空", maxLength = 32)
    @Schema(description = "结算主体id", name = "settleId")
    private String settleId;
    /**
     * 用户id
     */
    @NotBlank(message = "用户id不能为空")
    @Length(max = 32, message = "用户id不能超过32个字符")
    @ExcelAttribute(name = "用户id", isNotEmpty = true, errorInfo = "用户id不能为空", maxLength = 32)
    @Schema(description = "用户id", name = "userId")
    private String userId;
}
