/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户信息
 *
 * @author hgw
 * @date 2022-06-20 09:59:17
 */
@Data
@TableName("t_customer_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "客户信息")
public class TCustomerInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String customerCode;

	/**
	 * 省
	 */
	@Schema(description = "省")
	private Integer province;

	/**
	 * 市
	 */
	@Schema(description = "市")
	private Integer city;

	/**
	 * 县
	 */
	@Schema(description = "县")
	private Integer town;

	/**
	 * 单位客户地址
	 */
	@Schema(description = "单位客户地址")
	private String address;

	/**
	 * 客户性质
	 */
	@Schema(description = "客户性质")
	private String nature;

	/**
	 * 行业类型
	 */
	@Schema(description = "行业类型")
	private String industryBelong;

	/**
	 * 行业细分
	 */
	@Schema(description = "行业细分")
	private String industrySub;

	/**
	 * 业务经理审核状态（0是通过，1是不通过，2待审核，3待提交）
	 */
	@Schema(description = "业务经理审核状态（0是通过，1是不通过，2待审核，3待提交）")
	private String prAuditFlag;

	/**
	 * 合同状态 0正常1已停止
	 */
	@Schema(description = "合同状态 0正常1已停止")
	private String stopFlag;

	/**
	 * 删除标识（0未删除/1删除）
	 */
	@Schema(description = "删除标识（0未删除/1删除）")
	private String deleteFlag;

	/**
	 * 销售代表
	 */
	@Schema(description = "销售代表")
	private String salesman;

	/**
	 * 原ID（数据迁移）
	 */
	@Schema(description = "原ID（数据迁移）")
	private String oldId;

	/**
	 * 客户标识
	 */
	@Schema(description = "客户标识")
	private String label;

	/**
	 * 客户状态0合同未上传/1合同正常/2合同即将到期/3合同到期
	 */
	@Schema(description = "客户状态0合同未上传/1合同正常/2合同即将到期/3合同到期")
	private String customerStatus;

	/**
	 * 创建者姓名（冗余字段）
	 */
	@Schema(description = "创建者姓名（冗余字段）")
	private String createUserName;

	/**
	 * 最后修改人姓名
	 */
	@Schema(description = "最后修改人姓名")
	private String lastUpdateUserName;

	/**
	 * 销售代表姓名
	 */
	@Schema(description = "销售代表姓名")
	private String salesmanName;

	/**
	 * 业务经理审核意见
	 */
	@Schema(description = "业务经理审核意见")
	private String prAuditOpinion;

	/**
	 * 父级id，顶级的父级id为0
	 */
	@Schema(description = "父级id，顶级的父级id为0")
	private String parentId;

	/**
	 * 审核人id
	 */
	@Schema(description = "审核人id")
	private String prAuditMan;

	/**
	 * 审核人名称
	 */
	@Schema(description = "审核人名称")
	private String prAuditManName;

	/**
	 * 最后审核时间
	 */
	@Schema(description = "最后审核时间")
	private LocalDateTime lastAuditDate;

	/**
	 * 归属省
	 */
	@Schema(description = "归属省")
	private Integer belongProvince;

	/**
	 * 归属市
	 */
	@Schema(description = "归属市")
	private Integer belongCity;

	/**
	 * 归属区/县
	 */
	@Schema(description = "归属区/县")
	private Integer belongTown;

	/**
	 * 客户类型（0集团客户、1重点客户、2一般客户  3电信客户）
	 */
	@Schema(description = "客户类型（0集团客户、1重点客户、2一般客户  3电信客户）")
	private String customerType;

	/**
	 * 停止时间
	 */
	@Schema(description = "停止时间")
	private LocalDateTime stopDate;

	/**
	 * stopReason
	 */
	@Schema(description = "stopReason")
	private String stopReason;

	/**
	 * stopUser
	 */
	@Schema(description = "stopUser")
	private String stopUser;

	/**
	 * stopUserName
	 */
	@Schema(description = "stopUserName")
	private String stopUserName;

	/**
	 * 数据来源 0:当前系统 1 crm系统
	 */
	@Schema(description = "数据来源 0:当前系统 1 crm系统")
	private String dataSource;

	/**
	 * 账户余额
	 */
	@Schema(description = "账户余额")
	private BigDecimal balance;

	@TableField(exist = false)
	private List<String> customerIds;

}
