/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 员工家庭信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_emp_family")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工家庭信息表")
public class TEmpFamily extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 员工主键
     */
    @Schema(description ="员工主键")
    private String empId;

    /**
     * 员工编码
     */
    @Schema(description ="员工编码")
    private String empCode;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
    private String empName;

    /**
     * 身份证号
     */
    @Schema(description ="身份证号")
    private String empIdcard;

    /**
     * 与本人关系
     */
    @Schema(description ="与本人关系")
    private String relationshipSelf;

    /**
     * 家庭成员姓名
     */
    @Schema(description ="家庭成员姓名")
    private String familyName;

    /**
     * 出生日期
     */
	@TableField(value = "birthday", updateStrategy = FieldStrategy.IGNORED)
    @Schema(description ="出生日期")
    private LocalDateTime birthday;

    /**
     * 工作/学习单位
     */
    @Schema(description ="工作/学习单位")
    private String workUnit;

    /**
     * 联系电话
     */
    @Schema(description ="联系电话")
    private String contractTel;

    /**
     * 0删除作废1正常
     */
	@TableLogic
    @Schema(description ="0删除作废1正常")
    private String deleteFlag;
	/**
	 * 备注
	 */
	@Schema(description ="备注")
	private String remark;

	/**
	 * 项目ID
	 */
	@Schema(description ="项目ID")
	private String  settleDomain;

}
