/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 员工合同审批记录表
 *
 * @author hgw
 * @date 2022-06-30 20:39:54
 */
@Data
@TableName("t_employee_contract_audit")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工合同审批记录表")
public class TEmployeeContractAudit extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	private String remark;

	/**
	 * 审核状态：审核通过;审核不通过
	 */
	@Schema(description = "审核状态：审核通过;审核不通过")
	private String auditStatus;

	/**
	 * 合同ID
	 */
	@Schema(description = "合同ID")
	private String linkId;

	/**
	 * 类型：1合同
	 */
	@Schema(description = "类型：1合同")
	private Integer linkType;

	@Schema(description = "节点名称")
	private String rootName;


}
