/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 档案变更日志表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
@Data
@TableName("t_employee_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "档案变更日志表")
public class TEmployeeLog extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	/**
	 * 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新 4入职确认信息
	 */
	@Schema(description = "类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新；4入职确认信息")
	private Integer type;

	/**
	 * 档案id
	 */
	@Schema(description = "档案id")
	private String empId;

	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	private String projectId;

	/**
	 * 原来的信息
	 */
	@Schema(description = "原来的信息")
	private String oldInfo;
	/**
	 * 新的信息
	 */
	@Schema(description = "新的信息")
	private String newInfo;
	/**
	 * 差异的信息
	 */
	@Schema(description = "差异的信息")
	private String differenceInfo;

}
