/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 预入职-员工不良记录表
 *
 * @author hgw
 * @date 2024-06-17 11:31:08
 */
@Data
@TableName("t_pre_emp_bad_record")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工不良记录表")
public class TPreEmpBadRecord extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工ID
	 */
	@ExcelAttribute(name = "员工ID", maxLength = 32)
	@Length(max = 32, message = "员工ID不能超过32个字符")
	@ExcelProperty("员工ID")
	@Schema(description = "员工ID")
	private String empId;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 产生项目
	 */
	@ExcelAttribute(name = "产生项目", maxLength = 50)
	@Length(max = 50, message = "产生项目不能超过50个字符")
	@ExcelProperty("产生项目")
	@Schema(description = "产生项目")
	private String project;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String projectCode;
	/**
	 * 发生时间
	 */
	@ExcelAttribute(name = "发生时间", isDate = true)
	@ExcelProperty("发生时间")
	@Schema(description = "发生时间")
	private Date happenTime;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Length(max = 200, message = "备注不能超过200个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 费用损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "费用损失 （费用损失与其他费用损失其一必填）")
	@ExcelProperty("费用损失 （费用损失与其他费用损失其一必填）")
	@Schema(description = "费用损失 （费用损失与其他费用损失其一必填）")
	private BigDecimal loseFee;
	/**
	 * 其他损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "其他损失 （费用损失与其他费用损失其一必填）")
	@ExcelProperty("其他损失 （费用损失与其他费用损失其一必填）")
	@Schema(description = "其他损失 （费用损失与其他费用损失其一必填）")
	private BigDecimal loseFeeOther;

	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;

	/**
	 * @author chenyuxi
	 * @since  1.9.6
	 **/
	@Schema(description = "是否曾经或正在追究与承担过刑事责任 0 是 1 否")
	private String badRecordFlag;

}
