/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 预入职-员工家庭信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_family")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工家庭信息表")
public class TPreEmpFamily extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工主键
	 */
	@ExcelAttribute(name = "员工主键", isNotEmpty = true, errorInfo = "员工主键不能为空", maxLength = 32)
	@NotBlank(message = "员工主键不能为空")
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelProperty("员工主键")
	@Schema(description = "员工主键")
	private String empId;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelProperty("员工编码")
	@Schema(description = "员工编码")
	private String empCode;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 与本人关系
	 */
	@ExcelAttribute(name = "与本人关系", maxLength = 32)
	@Length(max = 32, message = "与本人关系不能超过32个字符")
	@ExcelProperty("与本人关系")
	@Schema(description = "与本人关系")
	private String relationshipSelf;
	/**
	 * 家庭成员姓名
	 */
	@ExcelAttribute(name = "家庭成员姓名", maxLength = 32)
	@Length(max = 32, message = "家庭成员姓名不能超过32个字符")
	@ExcelProperty("家庭成员姓名")
	@Schema(description = "家庭成员姓名")
	private String familyName;
	/**
	 * 出生日期
	 */
	@ExcelAttribute(name = "出生日期", isDate = true)
	@ExcelProperty("出生日期")
	@Schema(description = "出生日期")
	private Date birthday;
	/**
	 * 工作/学习单位
	 */
	@ExcelAttribute(name = "工作/学习单位", maxLength = 100)
	@Length(max = 100, message = "工作/学习单位不能超过100个字符")
	@ExcelProperty("工作/学习单位")
	@Schema(description = "工作/学习单位")
	private String workUnit;
	/**
	 * 联系电话
	 */
	@ExcelAttribute(name = "联系电话", maxLength = 32)
	@Length(max = 32, message = "联系电话不能超过32个字符")
	@ExcelProperty("联系电话")
	@Schema(description = "联系电话")
	private String contractTel;
	/**
	 * 0删除作废1正常
	 */
	@ExcelAttribute(name = "0删除作废1正常", maxLength = 1)
	@Length(max = 1, message = "0删除作废1正常不能超过1个字符")
	@ExcelProperty("0删除作废1正常")
	@Schema(description = "0删除作废1正常")
	private String deleteFlag;
	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Length(max = 200, message = "备注不能超过200个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

}
