/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 预入职审批记录表
 *
 * @author hgw
 * @date 2024-06-24 14:27:15
 */
@Data
@TableName("t_pre_emp_main_log")
@Schema(description = "预入职审批记录表")
public class TPreEmpMainLog implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 实体id
	 */
	@ExcelAttribute(name = "实体id", isNotEmpty = true, errorInfo = "实体id不能为空", maxLength = 32)
	@NotBlank(message = "实体id不能为空")
	@Length(max = 32, message = "实体id不能超过32个字符")
	@ExcelProperty("实体id")
	@Schema(description = "实体id")
	private String mainId;
	/**
	 * 审核人id
	 */
	@ExcelAttribute(name = "审核人id", isNotEmpty = true, errorInfo = "审核人id不能为空", maxLength = 32)
	@NotBlank(message = "审核人id不能为空")
	@Length(max = 32, message = "审核人id不能超过32个字符")
	@ExcelProperty("审核人id")
	@Schema(description = "审核人id")
	private String auditId;
	/**
	 * 审核人姓名
	 */
	@ExcelAttribute(name = "审核人姓名", isNotEmpty = true, errorInfo = "审核人姓名不能为空", maxLength = 50)
	@NotBlank(message = "审核人姓名不能为空")
	@Length(max = 50, message = "审核人姓名不能超过50个字符")
	@ExcelProperty("审核人姓名")
	@Schema(description = "审核人姓名")
	private String auditName;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@ExcelProperty("审核时间")
	@Schema(description = "审核时间")
	private Date auditTime;
	/**
	 * 审核结果 3审核不通过；4审核通过
	 */
	@ExcelAttribute(name = "审核结果", maxLength = 1)
	@Length(max = 1, message = "审核结果不能超过1个字符")
	@ExcelProperty("审核结果3审核不通过；4审核通过")
	@Schema(description = "审核结果3审核不通过；4审核通过")
	private String auditResult;
	/**
	 * 审核意见
	 */
	@ExcelAttribute(name = "审核意见", maxLength = 200)
	@Length(max = 200, message = "审核意见不能超过200个字符")
	@ExcelProperty("审核意见")
	@Schema(description = "审核意见")
	private String auditRemark;

}
