/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 预入职-其他附件主表
 *
 * @author hgw
 * @date 2024-07-17 14:56:34
 */
@Data
@TableName("t_pre_emp_other_file")
@Schema(description = "预入职-其他附件主表")
public class TPreEmpOtherFile {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工主键
	 */
	@ExcelAttribute(name = "员工主键", maxLength = 32)
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelProperty("员工主键")
	@Schema(description = "员工主键")
	private String empId;
	/**
	 * 附件名称
	 */
	@ExcelAttribute(name = "附件名称", maxLength = 32)
	@Length(max = 32, message = "附件名称不能超过32个字符")
	@ExcelProperty("附件名称")
	@Schema(description = "附件名称")
	private String attaName;
	/**
	 * 原ID
	 */
	@ExcelAttribute(name = "原ID", maxLength = 32)
	@Length(max = 32, message = "原ID不能超过32个字符")
	@ExcelProperty("原ID")
	@Schema(description = "原ID")
	private String oldId;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

	/**
	 * @Description: 其他附件
	 * @Author: hgw
	 * @Date: 2024/7/17 15:11
	 * @return:
	 **/
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

	/**
	 * 档案编辑其他附件分租信息处理类型 0 新增 1 更新 2 删除 3 不变
	 */
	@TableField(exist = false)
	private String handleType;

}
