/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 预入职-员工工作履历信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_work_recording")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工工作履历信息表")
public class TPreEmpWorkRecording extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工ID
	 */
	@ExcelAttribute(name = "员工ID", isNotEmpty = true, errorInfo = "员工ID不能为空", maxLength = 32)
	@NotBlank(message = "员工ID不能为空")
	@Length(max = 32, message = "员工ID不能超过32个字符")
	@ExcelProperty("员工ID")
	@Schema(description = "员工ID")
	private String empId;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelProperty("员工编码")
	@Schema(description = "员工编码")
	private String empCode;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 工作单位
	 */
	@ExcelAttribute(name = "工作单位", isNotEmpty = true, errorInfo = "工作单位不能为空", maxLength = 100)
	@NotBlank(message = "工作单位不能为空")
	@Length(max = 100, message = "工作单位不能超过100个字符")
	@ExcelProperty("工作单位")
	@Schema(description = "工作单位")
	private String workUnit;
	/**
	 * 工作部门
	 */
	@ExcelAttribute(name = "工作部门", isNotEmpty = true, errorInfo = "工作部门不能为空", maxLength = 100)
	@NotBlank(message = "工作部门不能为空")
	@Length(max = 100, message = "工作部门不能超过100个字符")
	@ExcelProperty("工作部门")
	@Schema(description = "工作部门")
	private String workDepart;
	/**
	 * 工作岗位
	 */
	@ExcelAttribute(name = "工作岗位", maxLength = 100)
	@Length(max = 100, message = "工作岗位不能超过100个字符")
	@ExcelProperty("工作岗位")
	@Schema(description = "工作岗位")
	private String workJob;
	/**
	 * 开始工作日期
	 */
	@ExcelAttribute(name = "开始工作日期", isNotEmpty = true, errorInfo = "开始工作日期不能为空", isDate = true)
	@NotBlank(message = "开始工作日期不能为空")
	@ExcelProperty("开始工作日期")
	@Schema(description = "开始工作日期")
	private Date startDate;
	/**
	 * 结束工作日期
	 */
	@ExcelAttribute(name = "结束工作日期", isDate = true)
	@ExcelProperty("结束工作日期")
	@Schema(description = "结束工作日期")
	private Date endDate;
	/**
	 * 在职状态0是/1否
	 */
	@ExcelAttribute(name = "在职状态0是/1否", maxLength = 32)
	@Length(max = 32, message = "在职状态0是/1否不能超过32个字符")
	@ExcelProperty("在职状态0是/1否")
	@Schema(description = "在职状态0是/1否")
	private String workingStatus;
	/**
	 * 人员类型
	 */
	@ExcelAttribute(name = "人员类型", maxLength = 32)
	@Length(max = 32, message = "人员类型不能超过32个字符")
	@ExcelProperty("人员类型")
	@Schema(description = "人员类型")
	private String workingType;
	/**
	 * 0删除作废1正常
	 */
	@ExcelAttribute(name = "0删除作废1正常", maxLength = 1)
	@Length(max = 1, message = "0删除作废1正常不能超过1个字符")
	@ExcelProperty("0删除作废1正常")
	@Schema(description = "0删除作废1正常")
	private String deleteFlag;
	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Length(max = 200, message = "备注不能超过200个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;

}
