package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2023/10/17
 * @Description
 * @Version 1.0
 */
@Data
public class DataPermissionImportVo  extends RowIndex implements Serializable {
	@ExcelAttribute(name = "登录账号", maxLength = 30,isNotEmpty = true)
	@Schema(description = "登录账号")
	private String userLoginName;

	@ExcelAttribute(name = "项目名称", maxLength = 32,isNotEmpty = false)
	@Schema(description = "项目名称")
	private String settleDomainName;

	@Length(max = 32, message = "项目编码不能超过32个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 32,isNotEmpty = true)
	@Schema(description = "项目编码")
	private String settleDomainNo;

}
