/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 员工合同-批量更新的VO
 *
 * @author hgw
 * @date 2022-7-1 17:40:40
 */
@Data
@Schema(description = "员工合同-批量更新的VO")
public class EmployeeContractUpdateVO extends RowIndex implements Serializable {

	/**
	 * 合同申请编码
	 */
	@Length(max = 50, message = "合同申请编码不能超过50个字符")
	@ExcelAttribute(name = "合同申请编码", isNotEmpty = true, maxLength = 50, needExport = true)
	@Schema(description = "合同申请编码", name = "applyNo")
	private String applyNo;

	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;

	/**
	 * 合同编号
	 */
	@Length(max = 50, message = "合同编号不能超过50个字符")
	@ExcelAttribute(name = "合同编号",  maxLength = 50)
	@Schema(description = "合同编号", name = "contractNo")
	private String contractNo;
	/**
	 * 档案柜号
	 */
	@Length(max = 50, message = "档案柜号不能超过50个字符")
	@ExcelAttribute(name = "档案柜号", maxLength = 50)
	@Schema(description = "档案柜号", name = "fileCabinetNo")
	private String fileCabinetNo;

}
