/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 项目档案表excel对应的实体
 *
 * @author huyc
 * @date 2022-06-20 17:54:40
 */
@Data
@ColumnWidth(30)
public class EmployeeVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工类型")
	private String empNatrue;

	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true, errorInfo = "员工姓名必填且不可超过20位")
	@Size(max = 20, message = "员工姓名不可超过20位")
	private String empName;

	/**
	 * 身份证号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20, needExport = true, errorInfo = "身份证号必填且不可超过20位")
	@Size(max = 20, message = "身份证号不可超过20位")
	private String empIdcard;

	/**
	 * 项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码")
	@ExcelAttribute(name = "项目编码", maxLength = 32, needExport = true, errorInfo = "项目编码必填且不可超过20位")
	@Size(max = 32, message = "项目编码不可超过32位")
	private String deptNo;

	/**
	 * 就职岗位
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "就职岗位")
	@Size(max = 50, message = "就职岗位不可超过50位")
	private String post;

	/**
	 * 身份证有效期起
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证开始日期")
	private Date validityStart;

	/**
	 * 身份证有效期止
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证截止日期")
	private Date validityEnd;

	/**
	 * 婚姻状况
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "婚姻状况")
	@Size(max = 32, message = "婚姻状况不可超过32位")
	private String empMarriStatus;

	/**
	 * 民族
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "民族")
	@Size(max = 32, message = "民族不可超过32位")
	private String empNational;

	/**
	 * 政治面貌
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "政治面貌")
	@Size(max = 32, message = "政治面貌不可超过32位")
	private String politicalStatus;

	/**
	 * 手机号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "手机号码")
	@Size(max = 11, message = "手机号码不可超过11位")
	private String empPhone;

	/**
	 * 邮箱
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "邮箱")
	@Size(max = 32, message = "邮箱不可超过32位")
	private String empEmail;

	/**
	 * 身份证-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在省")
	private String idProvince;

	/**
	 * 身份证-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在市")
	private String idCity;

	/**
	 * 身份证-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户籍所在县")
	private String idTown;

	/**
	 * 户口性质
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "户口性质")
	private String empRegisType;

	/**
	 * 档案-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在省")
	private String fileProvince;

	/**
	 * 档案-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在市")
	private String fileCity;

	/**
	 * 档案-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "档案所在县")
	private String fileTown;

	/**
	 * 是否大专及以上（0否1是）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否大专及以上")
	private String isCollege;

	/**
	 * 最高学历（字典值）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "最高学历")
	private String hignEducation;

	/**
	 * 学校
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "学校")
	private String school;

	/**
	 * 专业
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "专业")
	private String major;

	/**
	 * 入学时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "入学时间")
	private Date admissionDate;

	/**
	 * 毕业时间
	 */
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "毕业时间")
	private Date gradutionDate;

	/**
	 * 备注
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "备注")
	private String remark;

	/**
	 * 通信地址
	 */
	@Schema(description = "通信地址")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "通信地址")
	private String contactAddress;

}
