/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 封装-返回给前端的错误信息
 *
 * @author hgw
 * @date 2022-6-28 11:27:08
 */
@Data
public class ErrorMessageVO implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "行号")
	private int lineNum;

	@Schema(description = "员工姓名")
	private String empName;

	@Schema(description = "身份证号")
	private String empIdCard;

	@Schema(description = "结果：0错误；1正确（例如：是否允许删除：0否；1是）")
	private int result;

	@Schema(description = "错误信息Set（多重错误合并返回，给Set，前端按需组装）")
	private Set<String> errorSet;

}
