/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 *
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveCertificateVo implements Serializable {

	private static final long serialVersionUID = 1L;
	// 资格类型
	@Schema(description = "证照名称")
	private String certificateName;
	// 证书编号
	@Schema(description = "证照编号")
	private String certificateNo;
	// 评定机构
	@Schema(description = "发证机构")
	private String certificateOrg;
	// 无
	@Schema(description = "发证日期")
	private String certificateDate;
	// 无
	@Schema(description = "到期时间")
	private String certificateExpireDate;
	// 附件
	@Schema(description = "证照附件")
	private String annex;

}
