package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/7/20
 * @Description 项目结算信息表：包含项目信息 和 客户信息
 * @Version 1.0
 */
@Data
public class ProjectSetInfoVo implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String departNo;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String departName;

	/**
	 * 封面抬头
	 */
	@Schema(description = "封面抬头")
	private String invoiceTitle;

	/**
	 * 所属客户
	 */
	@Schema(description = "所属客户")
	private String customerId;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String customerCode;

	/**
	 * 商险结算类型：0预估  1 实缴
	 */
	@Schema(description = "商险结算类型")
	private String insuranceSettleType;

	/**
	 * 业务类型一级分类
	 */
	@Schema(description ="业务类型一级分类")
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@Schema(description ="业务类型二级分类")
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@Schema(description ="业务类型三级分类")
	private String businessThirdType;

	/**
	 * 服务状态：0正常 1停止服务 2冻结
	 */
	@Schema(description = "服务状态：0正常 1停止服务 2冻结")
	private String stopFlag;

	/**
	 * 封面抬头-薪资
	 */
	@Schema(description="封面抬头-薪资")
	private String invoiceTitleSalary;
	/**
	 * 封面抬头-商险
	 */
	@Schema(description="封面抬头-商险")
	private String invoiceTitleInsurance;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	@ExcelIgnore
	private String bpoFlag;
}
