/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 字典表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
public class SysAutoDictVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空")
	@Schema(description = "id")
	@ExcelProperty("id")
	private Long id;
	/**
	 * 字典编码
	 */
	@Length(max = 100, message = "字典编码 不能超过100 个字符")
	@ExcelAttribute(name = "字典编码", maxLength = 100)
	@Schema(description = "字典编码")
	@ExcelProperty("字典编码")
	private String type;
	/**
	 * 字典名称
	 */
	@Length(max = 100, message = "字典名称 不能超过100 个字符")
	@ExcelAttribute(name = "字典名称", maxLength = 100)
	@Schema(description = "字典名称")
	@ExcelProperty("字典名称")
	private String description;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符")
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注")
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 是否是系统内置
	 */
	@Length(max = 1, message = "是否是系统内置 不能超过1 个字符")
	@ExcelAttribute(name = "是否是系统内置", maxLength = 1)
	@Schema(description = "是否是系统内置")
	@ExcelProperty("是否是系统内置")
	private String systemFlag;
	/**
	 * 删除标记
	 */
	@Length(max = 1, message = "删除标记 不能超过1 个字符")
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Schema(description = "删除标记")
	@ExcelProperty("删除标记")
	private String delFlag;
	/**
	 * 联动上级类型
	 */
	@Length(max = 32, message = "联动上级类型 不能超过32 个字符")
	@ExcelAttribute(name = "联动上级类型", maxLength = 32)
	@Schema(description = "联动上级类型")
	@ExcelProperty("联动上级类型")
	private String parentItemType;
	/**
	 * 创建人姓名
	 */
	@Length(max = 32, message = "创建人姓名 不能超过32 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 客户端标识
	 */
	@Length(max = 32, message = "客户端标识 不能超过32 个字符")
	@ExcelAttribute(name = "客户端标识", maxLength = 32)
	@Schema(description = "客户端标识")
	@ExcelProperty("客户端标识")
	private String clientId;

}
