
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@Data
public class TCompleteMonitorVo implements Serializable {

	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@ExcelProperty("客户名称")
	private String unitName;

	/**
	 * 客户编码
	 */
	@Length(max = 32, message = "客户编码 不能超过32 个字符")
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Schema(description = "客户编码")
	@ExcelProperty("客户编码")
	private String unitNo;

	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	/**
	 * 项目编码
	 */
	@NotBlank(message = "项目编码 不能为空")
	@Length(max = 30, message = "项目编码 不能超过30 个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 30)
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	/**
	 * 业务类型一级分类
	 */
	@Length(max = 64, message = "业务类型一级分类 不能超过64 个字符")
	@ExcelAttribute(name = "业务类型", maxLength = 64)
	@Schema(description = "业务类型")
	@ExcelProperty("业务类型")
	private String businessPrimaryType;

	/**
	 * 在项人数
	 */
	@ExcelAttribute(name = "在项人数")
	@Schema(description = "在项人数")
	@ExcelProperty("在项人数")
	private Integer inusePersonNum;

	/**
	 * 信息是否完整
	 */
	@Length(max = 1, message = "信息是否完整 不能超过1 个字符")
	@ExcelAttribute(name = "信息是否完整", maxLength = 1, readConverterExp = "0=是,1=否")
	@Schema(description = "信息是否完整")
	@ExcelProperty("信息是否完整")
	private String isComplete;

	/**
	 * 信息不完整人数
	 */
	@ExcelAttribute(name = "信息不完整人数")
	@Schema(description = "信息不完整人数")
	@ExcelProperty("信息不完整人数")
	private Integer incompleteNum;

	/**
	 * 完整度占比
	 */
	@Length(max = 8, message = "完整度占比 不能超过8 个字符")
	@ExcelAttribute(name = "完整度占比", maxLength = 8)
	@Schema(description = "完整度占比")
	@ExcelProperty("完整度占比")
	private String completePer;

	/**
	 * 10月及后入职人数
	 */
	@ExcelAttribute(name = "10月及后入职人数")
	@Schema(description = "10月及后入职人数")
	@ExcelProperty("10月及后入职人数")
	private Integer afterEmployment;

	/**
	 * 10月及后入职信息是否完整
	 */
	@Length(max = 1, message = "10月及后入职信息是否完整 不能超过1 个字符")
	@ExcelAttribute(name = "10月及后入职信息是否完整", maxLength = 1, readConverterExp = "0=是,1=否")
	@Schema(description = "10月及后入职信息是否完整")
	@ExcelProperty("10月及后入职信息是否完整")
	private String afterIsComplete;

	/**
	 * 10月及后入职信息不完整人数
	 */
	@ExcelAttribute(name = "10月及后入职信息不完整人数")
	@Schema(description = "10月及后入职信息不完整人数")
	@ExcelProperty("10月及后入职信息不完整人数")
	private Integer afterIncompleteNum;

	/**
	 * 立项申请人
	 */
	@Length(max = 32, message = "立项申请人 不能超过32 个字符")
	@ExcelAttribute(name = "立项申请人", maxLength = 32)
	@Schema(description = "立项申请人")
	@ExcelProperty("立项申请人")
	private String alertUser;

}
