/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 预入职批量完善信息使用
 *
 * @author hgw
 * @date 2024-06-17 11:31:08
 */
@Data
public class TPreEmpMainVo extends RowIndex implements Serializable {

	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@ExcelProperty("员工姓名")
	private String empName;
	@Length(max = 32, message = "项目编码 不能超过32 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 32)
	@ExcelProperty("项目编码")
	private String deptNo;
	@ExcelAttribute(name = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@ExcelProperty("员工类型")
	private String empNatrue;
	@ExcelAttribute(name = "档案所在地省", isArea = true, isNotEmpty = true, errorInfo = "档案所在地省不能为空")
	@ExcelProperty("档案所在地省")
	private String fileProvince;
	@ExcelAttribute(name = "档案所在地市", isArea = true, parentField = "fileProvince", isNotEmpty = true, errorInfo = "档案所在地市不能为空")
	@ExcelProperty("档案所在地市")
	private String fileCity;
	@ExcelAttribute(name = "档案所在地县", isArea = true, parentField = "fileCity", isNotEmpty = false, errorInfo = "档案所在地县不能为空")
	@ExcelProperty("档案所在地县")
	private String fileTown;
	@ExcelAttribute(name = "计税月份")
	@ExcelProperty("计税月份")
	private String taxMonth;

}
