/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddCompanyInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddPersonAccount;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddPersonAccountService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


/**
 * 法大大个人实名认证表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddpersonaccount" )
@Tag(name = "法大大个人实名认证表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddPersonAccountController {

	private final FddPersonAccountService fddPersonAccountService;

	/**
	 * 分页查询
	 * @param page 分页对象
	 * @param fddPersonAccount 法大大个人实名认证表
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R getFddPersonAccountPage(Page page, FddPersonAccount fddPersonAccount) {
		return R.ok(fddPersonAccountService.getFddPersonAccountPage(page, fddPersonAccount));
	}

	/**
	 * 通过id查询法大大个人实名认证表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}" )
	public R getById(@PathVariable("id") String id) {
		return R.ok(fddPersonAccountService.getById(id));
	}

	/**
	 * 新增法大大个人实名认证表
	 * @param fddPersonAccount 法大大个人实名认证表
	 * @return R
	 */
	@Operation(summary = "新增法大大个人实名认证表", description = "新增法大大个人实名认证表：hasPermission('demo_fddpersonaccount_add')")
	@SysLog("新增法大大个人实名认证表" )
	@PostMapping
	@PreAuthorize("@pms.hasPermission('demo_fddpersonaccount_add')" )
	public R saveAuth(@RequestBody FddPersonAccount fddPersonAccount) {
		return fddPersonAccountService.saveInfo(fddPersonAccount);
	}

	/**
	 * 修改法大大个人实名认证表
	 * @param fddPersonAccount 法大大个人实名认证表
	 * @return R
	 */
	@Operation(summary = "修改法大大个人实名认证表", description = "修改法大大个人实名认证表：hasPermission('demo_fddpersonaccount_edit')")
	@SysLog("修改法大大个人实名认证表" )
	@PutMapping
	@PreAuthorize("@pms.hasPermission('demo_fddpersonaccount_edit')" )
	public R updateById(@RequestBody FddPersonAccount fddPersonAccount) {
		return R.ok(fddPersonAccountService.updateById(fddPersonAccount));
	}

	/**
	 * 通过id删除法大大个人实名认证表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除法大大个人实名认证表", description = "通过id删除法大大个人实名认证表：hasPermission('demo_fddpersonaccount_del')")
	@SysLog("通过id删除法大大个人实名认证表" )
	@DeleteMapping("/{id}" )
	@PreAuthorize("@pms.hasPermission('demo_fddpersonaccount_del')" )
	public R removeById(@PathVariable String id) {
		return R.ok(fddPersonAccountService.removeById(id));
	}

	/**
	 * 邀请客服进行法大大实名
	 * @param fddPersonAccount
	 * @return R
	 */
	@Operation(summary = "邀请客服进行法大大实名", description = "邀请客服进行法大大实名")
	@SysLog("邀请客服进行法大大实名" )
	@PostMapping("/saneSend")
	public R<String> save(@Valid @RequestBody FddPersonAccount fddPersonAccount) throws ApiException {
		return fddPersonAccountService.getPersonUnionIdUrl(fddPersonAccount);
	}

	/**
	 * 邀请客服加入组织
	 * @param fddPersonAccount
	 * @return R
	 */
	@Operation(summary = "邀请客服加入组织", description = "邀请客服加入组织")
	@PostMapping("/getAddEmployeeUrl")
	public R<String> getAddEmployeeUrl(@Valid @RequestBody List<FddPersonAccount> fddPersonAccount) throws ApiException {
		return fddPersonAccountService.getAddEmployeeUrl(fddPersonAccount);
	}

	/**
	 * 主动发送员工进行法大大实名
	 * @param id
	 * @return R
	 */
	@Operation(summary = "主动发送员工进行法大大实名", description = "主动发送员工进行法大大实名")
	@PostMapping("/sendAuthMessage")
	public R<String> sendAuthMessage(@RequestParam String id) throws ApiException {
		return fddPersonAccountService.sendAuthMessage(id);
	}

	/**
	 * 移除员工
	 * @param id
	 * @return R
	 */
	@Operation(summary = "移除员工", description = "移除员工")
	@PostMapping("/delEmployee")
	public R<String> delEmployee(@RequestParam(name = "id") String id,@RequestParam(name = "companyUnionIds") List<String> companyUnionIds, @RequestParam(name = "unionIds") String unionIds) throws ApiException {
		return fddPersonAccountService.delEmployee(id,companyUnionIds,unionIds);
	}

	/**
	 * 获取员工加入的组织
	 * @param id
	 * @return R
	 */
	@Operation(summary = "获取员工加入的组织", description = "获取员工加入的组织")
	@PostMapping("/getAllDepart")
	public R<List<FddCompanyInfo>> getAllDepart(@RequestParam String id){
		return fddPersonAccountService.getAllDepart(id);
	}
}
