/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddTemplateFieldInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddTemplateFieldInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 法大大字段对应信息表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddtemplatefieldinfo" )
@Tag(name = "法大大字段对应信息表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddTemplateFieldInfoController {

    private final FddTemplateFieldInfoService fddTemplateFieldInfoService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param fddTemplateFieldInfo 法大大字段对应信息表
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    @PreAuthorize("@pms.hasPermission('demo_fddtemplatefieldinfo_get')" )
    public R getFddTemplateFieldInfoPage(Page page, FddTemplateFieldInfo fddTemplateFieldInfo) {
        return R.ok(fddTemplateFieldInfoService.page(page, Wrappers.query(fddTemplateFieldInfo)));
    }


    /**
     * 通过id查询法大大字段对应信息表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_fddtemplatefieldinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_fddtemplatefieldinfo_get')" )
    public R getById(@PathVariable("id" ) String id) {
        return R.ok(fddTemplateFieldInfoService.getById(id));
    }

    /**
     * 新增法大大字段对应信息表
     * @param fddTemplateFieldInfo 法大大字段对应信息表
     * @return R
     */
    @Operation(summary = "新增法大大字段对应信息表", description = "新增法大大字段对应信息表：hasPermission('demo_fddtemplatefieldinfo_add')")
    @SysLog("新增法大大字段对应信息表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_fddtemplatefieldinfo_add')" )
    public R save(@RequestBody FddTemplateFieldInfo fddTemplateFieldInfo) {
        return R.ok(fddTemplateFieldInfoService.save(fddTemplateFieldInfo));
    }

    /**
     * 修改法大大字段对应信息表
     * @param fddTemplateFieldInfo 法大大字段对应信息表
     * @return R
     */
    @Operation(summary = "修改法大大字段对应信息表", description = "修改法大大字段对应信息表：hasPermission('demo_fddtemplatefieldinfo_edit')")
    @SysLog("修改法大大字段对应信息表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_fddtemplatefieldinfo_edit')" )
    public R updateById(@RequestBody FddTemplateFieldInfo fddTemplateFieldInfo) {
        return R.ok(fddTemplateFieldInfoService.updateById(fddTemplateFieldInfo));
    }

    /**
     * 通过id删除法大大字段对应信息表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除法大大字段对应信息表", description = "通过id删除法大大字段对应信息表：hasPermission('demo_fddtemplatefieldinfo_del')")
    @SysLog("通过id删除法大大字段对应信息表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_fddtemplatefieldinfo_del')" )
    public R removeById(@PathVariable String id) {
        return R.ok(fddTemplateFieldInfoService.removeById(id));
    }

}
